/*
 * Copyright 2020 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * On supported devices, represents a depth image based {@link com.google.ar.core.HitResult
 * HitResult} returned by {@link com.google.ar.core.Frame#hitTest(float,float) }. Only available
 * when {@link com.google.ar.core.Config#setDepthMode(com.google.ar.core.Config.DepthMode)
 * Config#setDepthMode(Config.DepthMode)} has been set to {@link
 * com.google.ar.core.Config.DepthMode#AUTOMATIC Config.DepthMode#AUTOMATIC}.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DepthPoint implements com.google.ar.core.Trackable {

  DepthPoint() {
    // Method contents removed.
  }

  /** Gets this trackable's {@link com.google.ar.core.TrackingState TrackingState}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState() {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor createAnchor(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code Trackable} referencing the same logical
   * trackable as this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public java.util.Collection<com.google.ar.core.Anchor> getAnchors() {
    // Method contents removed.
  }
}
