/*
 * Copyright 2022 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** The state of an asynchronous operation. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum FutureState {
  /**
   * The operation is still pending. The result of the operation isn't available yet, and any
   * associated callback hasn't yet been dispatched or invoked.
   *
   * <p>Do not use this to check if the operation can be cancelled as the state can change from
   * another thread between the call to {@link com.google.ar.core.VpsAvailabilityFuture#getState()
   * VpsAvailabilityFuture#getState()} and {@link com.google.ar.core.VpsAvailabilityFuture#cancel()
   * }
   */
  PENDING,
  /** The operation has been cancelled. Any associated callback will never be invoked. */
  CANCELLED,
  /**
   * The operation is complete and the result is available. If a callback was associated, it will
   * soon be invoked with the result on the main thread, if it hasn't been invoked already.
   */
  DONE;
}
