/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** Defines an intersection between a ray and estimated real-world geometry. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class HitResult {

  HitResult() {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code HitResult} referencing the same logical hit
   * result as this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /**
   * Returns the pose of the intersection between a ray and detected real-world geometry. The
   * position is the location in space where the ray intersected the geometry. The orientation is a
   * best effort to face the ray origin, and its exact definition differs depending on the Trackable
   * that was hit.
   *
   * <p>{@link com.google.ar.core.Plane Plane}: X+ is perpendicular to the cast ray and parallel to
   * the plane, Y+ points along the plane normal (up, for {@link
   * com.google.ar.core.Plane.Type#HORIZONTAL_UPWARD_FACING Plane.Type#HORIZONTAL_UPWARD_FACING}
   * planes), and Z+ is parallel to the plane, pointing roughly toward the ray origin.
   *
   * <p>{@link com.google.ar.core.Point Point}: Attempt to estimate the normal of the surface
   * centered around the hit test. Surface normal estimation is most likely to succeed on textured
   * surfaces and with camera motion. If {@link com.google.ar.core.Point#getOrientationMode()
   * Point#getOrientationMode()} returns {@link
   * com.google.ar.core.Point.OrientationMode#ESTIMATED_SURFACE_NORMAL }, then X+ is perpendicular
   * to the cast ray and parallel to the physical surface centered around the hit test, Y+ points
   * along the estimated surface normal, and Z+ points roughly toward the ray origin. If {@link
   * com.google.ar.core.Point#getOrientationMode() } returns {@link
   * com.google.ar.core.Point.OrientationMode#INITIALIZED_TO_IDENTITY
   * Point.OrientationMode#INITIALIZED_TO_IDENTITY}, then X+ is perpendicular to the cast ray and
   * points right from the perspective of the ray origin, Y+ points up, and Z+ points roughly toward
   * the ray origin.
   *
   * <p>If you wish to retain the location of this pose beyond the duration of a single frame,
   * create an {@link com.google.ar.core.Anchor Anchor} using {@link #createAnchor()} to save the
   * pose in a physically consistent way.
   *
   * @see #createAnchor()
   */
  public com.google.ar.core.Pose getHitPose() {
    // Method contents removed.
  }

  /** Returns the distance from the camera to the hit location, in meters. */
  public float getDistance() {
    // Method contents removed.
  }

  /** Returns the {@link com.google.ar.core.Trackable Trackable} that was hit. */
  public com.google.ar.core.Trackable getTrackable() {
    // Method contents removed.
  }

  /**
   * Creates a new anchor at the hit location. See {@link #getHitPose()} for details.
   *
   * <p>Anchors incur ongoing processing overhead within ARCore. To release unneeded anchors use
   * {@link com.google.ar.core.Anchor#detach() Anchor#detach()}.
   *
   * <p>This method is a convenience alias for {@code
   * hitResult.getTrackable().createAnchor(hitResult.getHitPose())}
   *
   * @see com.google.ar.core.Trackable#createAnchor(Pose)
   * @see #getHitPose()
   * @throws com.google.ar.core.exceptions.NotTrackingException if the trackable's tracking state
   *     was not {@link com.google.ar.core.TrackingState#TRACKING TrackingState#TRACKING}
   * @throws com.google.ar.core.exceptions.SessionPausedException if the session had been paused.
   * @throws com.google.ar.core.exceptions.ResourceExhaustedException if too many anchors exist.
   * @throws com.google.ar.core.exceptions.DeadlineExceededException if the hit result originates
   *     from an old {@link com.google.ar.core.Frame}.
   */
  public com.google.ar.core.Anchor createAnchor() {
    // Method contents removed.
  }
}
