/*
 * Copyright 2023 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Handle to an async operation launched by {@link
 * com.google.ar.core.Session#hostCloudAnchorAsync(com.google.ar.core.Anchor,int,java.util.function.BiConsumer)
 * Session#hostCloudAnchorAsync(Anchor, int, BiConsumer)}. See the <a
 * href="https://developers.google.com/ar/develop/java/cloud-anchors/developer-guide">Cloud Anchors
 * developer guide</a> for more information.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class HostCloudAnchorFuture implements com.google.ar.core.Future {

  HostCloudAnchorFuture() {
    // Method contents removed.
  }

  /**
   * Returns the Cloud Anchor ID of the hosted anchor. The returned result is only valid when {@link
   * com.google.ar.core.Future#getState() } returns {@link com.google.ar.core.FutureState#DONE
   * FutureState#DONE} and {@link #getResultCloudAnchorState()} returns {@link
   * com.google.ar.core.Anchor.CloudAnchorState#SUCCESS Anchor.CloudAnchorState#SUCCESS}.
   */
  @androidx.annotation.Nullable
  public java.lang.String getResultCloudAnchorId() {
    // Method contents removed.
  }

  /**
   * Returns the result status of the hosting operation, when {@link
   * com.google.ar.core.Future#getState() Future#getState()} returns {@link
   * com.google.ar.core.FutureState#DONE FutureState#DONE}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor.CloudAnchorState getResultCloudAnchorState() {
    // Method contents removed.
  }

  public boolean cancel() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.FutureState getState() {
    // Method contents removed.
  }
}
