/*
 * Copyright 2019 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** Image formats produced by ARCore. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ImageFormat {

  ImageFormat() {
    // Method contents removed.
  }

  /**
   * Produced by {@link com.google.ar.core.LightEstimate#acquireEnvironmentalHdrCubeMap()
   * LightEstimate#acquireEnvironmentalHdrCubeMap()}.
   *
   * <p>See <a
   * href="https://developer.android.com/ndk/reference/group/media#group___media_1gga9c3dace30485a0f28163a882a5d65a19aa0f5b9a07c9f3dc8a111c0098b18363a">
   * Android NDK {@code AIMAGE_FORMAT_RGBA_FP16}</a>.
   */
  public static final int RGBA_FP16 = 22; // 0x16

  /**
   * Produced by {@link com.google.ar.core.Frame#acquireRawDepthConfidenceImage()
   * Frame#acquireRawDepthConfidenceImage()}.
   *
   * <p>See <a href="https://developer.android.com/reference/android/graphics/ImageFormat.html#Y8">
   * Android NDK {@code AIMAGE_FORMAT_Y8}</a>.
   */
  public static final int Y8 = 538982489; // 0x20203859

  /**
   * Produced by {@link com.google.ar.core.Frame#acquireCameraImage() Frame#acquireCameraImage()}.
   *
   * <p>See <a
   * href="https://developer.android.com/reference/android/graphics/ImageFormat.html#YUV_420_888">
   * {@code android.graphics.ImageFormat.YUV_420_888}</a>
   */
  public static final int YUV_420_888 = 35; // 0x23
}
