/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Provides access to metadata from the camera image capture result.
 *
 * <p>For details on individual keys, see the reference information for the similarly named constant
 * in the <a href="https://developer.android.com/ndk/reference/group___camera.html">NDK Camera
 * documentation</a>.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ImageMetadata {

  ImageMetadata() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /** Returns the list of all metadata keys available for this image. */
  public long[] getKeys() {
    // Method contents removed.
  }

  /**
   * Retrieves the scalar byte value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that is a
   *     single byte.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public byte getByte(int key) throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the scalar integer value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that is a
   *     single integer.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public int getInt(int key) throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the scalar floating point value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that is a
   *     single float.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public float getFloat(int key) throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the scalar long value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that is a
   *     single long.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public long getLong(int key) throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the scalar double value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that is a
   *     single double.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public double getDouble(int key) throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the scalar {@link android.util.Rational Rational} value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that is a
   *     single {@link android.util.Rational Rational}.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public android.util.Rational getRational(int key)
      throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the byte array value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that has
   *     type byte.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public byte[] getByteArray(int key)
      throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the integer array value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that has
   *     type int.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public int[] getIntArray(int key) throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the float array value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that has
   *     type float.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public float[] getFloatArray(int key)
      throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the long array value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that has
   *     type long.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public long[] getLongArray(int key)
      throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the double array value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that has
   *     type double.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public double[] getDoubleArray(int key)
      throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Retrieves the {@link android.util.Rational Rational} array value for a specific key.
   *
   * @throws java.lang.IllegalArgumentException if the {@code key} does not select a value that has
   *     type {@link android.util.Rational Rational}.
   * @throws com.google.ar.core.exceptions.MetadataNotFoundException if the camera image metadata
   *     does not contain the {@code key}.
   */
  public android.util.Rational[] getRationalArray(int key)
      throws com.google.ar.core.exceptions.MetadataNotFoundException {
    // Method contents removed.
  }

  /**
   * Whether black-level compensation is locked to its current values, or is free to vary. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a61b33c3a358aee8260517ad6b5078e4c">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int BLACK_LEVEL_LOCK = 1441792; // 0x160000

  /**
   * Mode of operation for the chromatic aberration correction algorithm. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627acfea48cedf8d9a9f1025a3b1d90f07d4">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int COLOR_CORRECTION_ABERRATION_MODE = 3; // 0x3

  /**
   * Gains applying to Bayer raw color channels for white-balance. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ae756c32527481449d5fbf1f1825784de">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int COLOR_CORRECTION_GAINS = 2; // 0x2

  /**
   * The mode control selects how the image data is converted from the sensor's native color into
   * linear sRGB color. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a2c1e3cfe9b12b3e871616ce676e4f0d4">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int COLOR_CORRECTION_MODE = 0; // 0x0

  /**
   * A color transform matrix to use to transform from sensor RGB color space to output linear sRGB
   * color space. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a6f6c8994b77ab847e7b3dadd2ab359b3">Android
   * NDK Docs</a> for details. Access using {@link #getRationalArray(int)}.
   */
  public static final int COLOR_CORRECTION_TRANSFORM = 1; // 0x1

  /**
   * The desired setting for the camera device's auto-exposure algorithm's antibanding compensation.
   * See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a4ba881241e247e8ed05fd8668377bb5a">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AE_ANTIBANDING_MODE = 65536; // 0x10000

  /**
   * Adjustment to auto-exposure (AE) target image brightness. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a925166239f8ea81e694ef1a82ec5dbcc">Android
   * NDK Docs</a> for details. Access using {@link #getInt(int)}.
   */
  public static final int CONTROL_AE_EXPOSURE_COMPENSATION = 65537; // 0x10001

  /**
   * Whether auto-exposure (AE) is currently locked to its latest calculated values. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a7733a2c8dece58fe773f29a53605a35a">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AE_LOCK = 65538; // 0x10002

  /**
   * The desired mode for the camera device's auto-exposure routine. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ad1bc024e2656d7bf5df8e9ab04dddf89">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AE_MODE = 65539; // 0x10003

  /**
   * Whether the camera device will trigger a precapture metering sequence when it processes this
   * request. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aa3053f6e8d6abf294d07c8339eea3b3e">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AE_PRECAPTURE_TRIGGER = 65542; // 0x10006

  /**
   * List of metering areas to use for auto-exposure adjustment. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a2af319baaab119f6036c0b764c27b95d">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int CONTROL_AE_REGIONS = 65540; // 0x10004

  /**
   * Current state of the auto-exposure (AE) algorithm. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a5895913715b46ae7ad65a81b3abbb34c">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AE_STATE = 65567; // 0x1001f

  /**
   * Range over which the auto-exposure routine can adjust the capture frame rate to maintain good
   * exposure. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a61fbbc5aba358a63e64383902ef9c707">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int CONTROL_AE_TARGET_FPS_RANGE = 65541; // 0x10005

  /**
   * Whether auto-focus (AF) is currently enabled, and what mode it is set to. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aa35133d89fcf292fc6a842f3da0abdd1">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AF_MODE = 65543; // 0x10007

  /**
   * List of metering areas to use for auto-focus. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aea53499a61d6990c480093da7513bc5e">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int CONTROL_AF_REGIONS = 65544; // 0x10008

  /**
   * Current state of auto-focus (AF) algorithm. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ab2b5f4d9925cff9b133bd6a3ec44113c">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AF_STATE = 65568; // 0x10020

  /**
   * Whether the camera device will trigger autofocus for this request. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a2cb935e81a65b63f91552892da5f89d4">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AF_TRIGGER = 65545; // 0x10009

  /**
   * Whether auto-white balance (AWB) is currently locked to its latest calculated values. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ab82200256aa2f9b51aeb851e2b6ceb3c">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AWB_LOCK = 65546; // 0x1000a

  /**
   * Whether auto-white balance (AWB) is currently setting the color transform fields, and what its
   * illumination target is. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ac68e87801de1a0f12b5fffd5ac02ae18">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AWB_MODE = 65547; // 0x1000b

  /**
   * List of metering areas to use for auto-white-balance illuminant estimation. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a6ea906d67b86a5e77fddd484ca73c9b2">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int CONTROL_AWB_REGIONS = 65548; // 0x1000c

  /**
   * Current state of auto-white balance (AWB) algorithm. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a61732ed4309778f17219f151ed9bd891">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_AWB_STATE = 65570; // 0x10022

  /**
   * Information to the camera device 3A (auto-exposure, auto-focus, auto-white balance) routines
   * about the purpose of this capture, to help the camera device to decide optimal 3A strategy. See
   * <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a69406ccab3955d53689265c5a17ac60d">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_CAPTURE_INTENT = 65549; // 0x1000d

  /**
   * A special color effect to apply. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a8f14651fd11d5f81a415aaa80efa419e">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_EFFECT_MODE = 65550; // 0x1000e

  /**
   * Overall mode of 3A (auto-exposure, auto-white-balance, auto-focus) control routines. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a5a4631d8cce8a009eee171c5e0d16abf">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_MODE = 65551; // 0x1000f

  /**
   * The amount of additional sensitivity boost applied to output images after RAW sensor data is
   * captured. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a2f1ee3a4384948d244b2944b9fc6fd86">Android
   * NDK Docs</a> for details. Access using {@link #getInt(int)}.
   */
  public static final int CONTROL_POST_RAW_SENSITIVITY_BOOST = 65576; // 0x10028

  /**
   * Control for which scene mode is currently active. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a31753ecd5df260d347e59f806a4a86fe">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_SCENE_MODE = 65552; // 0x10010

  /**
   * Whether video stabilization is active. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aaa7c826a8a27499cbc71c1d691131694">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int CONTROL_VIDEO_STABILIZATION_MODE = 65553; // 0x10011

  /**
   * Operation mode for edge enhancement. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ae290097b05e2877a578c8e504293a6fd">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int EDGE_MODE = 196608; // 0x30000

  /**
   * The desired mode for the camera device's flash control. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a51fa10048612b61e353fbe3108f0ce5d">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int FLASH_MODE = 262146; // 0x40002

  /**
   * Current state of the flash unit. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aba7a8bfc2924af0d628fdf310efa5775">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int FLASH_STATE = 262149; // 0x40005

  /**
   * Operational mode for hot pixel correction. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a72456dc9ed6eb498c016a8544c5f168a">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int HOT_PIXEL_MODE = 393216; // 0x60000

  /**
   * GPS coordinates to include in output JPEG EXIF. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a3031dcbc6b6648003d455b88d0445c93">Android
   * NDK Docs</a> for details. Access using {@link #getDoubleArray(int)}.
   */
  public static final int JPEG_GPS_COORDINATES = 458752; // 0x70000

  /**
   * 32 characters describing GPS algorithm to include in EXIF. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a2b0b5012591734aa605be91518537084">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int JPEG_GPS_PROCESSING_METHOD = 458753; // 0x70001

  /**
   * Time GPS fix was made to include in EXIF. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a97bfd98fcb9a7b7d079f8b6f972d8f8a">Android
   * NDK Docs</a> for details. Access using {@link #getLong(int)}.
   */
  public static final int JPEG_GPS_TIMESTAMP = 458754; // 0x70002

  /**
   * The orientation for a JPEG image. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a25400e923ec347e3d28a50be1d27940f">Android
   * NDK Docs</a> for details. Access using {@link #getInt(int)}.
   */
  public static final int JPEG_ORIENTATION = 458755; // 0x70003

  /**
   * Compression quality of the final JPEG image. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a1e612dde426188b6db880c89bc227d90">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int JPEG_QUALITY = 458756; // 0x70004

  /**
   * Compression quality of JPEG thumbnail. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a6e29d5904b3fae4d21ae6e720eeee2e3">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int JPEG_THUMBNAIL_QUALITY = 458757; // 0x70005

  /**
   * Resolution of embedded JPEG thumbnail. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a3a1131a1d8ca89cebc5e07450ef56a33">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int JPEG_THUMBNAIL_SIZE = 458758; // 0x70006

  /**
   * The desired lens aperture size, as a ratio of lens focal length to the effective aperture
   * diameter. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a38d457fce67e70d9a7dc0a9823324c3e">Android
   * NDK Docs</a> for details. Access using {@link #getFloat(int)}.
   */
  public static final int LENS_APERTURE = 524288; // 0x80000

  /**
   * The desired setting for the lens neutral density filter(s). See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a1d66e60c48bb9ad343b2e5861933bae5">Android
   * NDK Docs</a> for details. Access using {@link #getFloat(int)}.
   */
  public static final int LENS_FILTER_DENSITY = 524289; // 0x80001

  /**
   * The desired lens focal length; used for optical zoom. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a80c64bc4bc6c46d2419476348966e162">Android
   * NDK Docs</a> for details. Access using {@link #getFloat(int)}.
   */
  public static final int LENS_FOCAL_LENGTH = 524290; // 0x80002

  /**
   * Desired distance to plane of sharpest focus, measured from frontmost surface of the lens. See
   * <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a3988ce2fc97b7b1f0d556370499edc69">Android
   * NDK Docs</a> for details. Access using {@link #getFloat(int)}.
   */
  public static final int LENS_FOCUS_DISTANCE = 524291; // 0x80003

  /**
   * The range of scene distances that are in sharp focus (depth of field). See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a0d959a69da21d79d0cf2f4c5e644c08e">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int LENS_FOCUS_RANGE = 524296; // 0x80008

  /**
   * The parameters for this camera device's intrinsic calibration. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a66d6a131c904f73672c2a6f75a169532">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int LENS_INTRINSIC_CALIBRATION = 524298; // 0x8000a

  /**
   * Sets whether the camera device uses optical image stabilization (OIS) when capturing images.
   * See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ab95d08bb123eaf6a71d185144a1ebc6b">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int LENS_OPTICAL_STABILIZATION_MODE = 524292; // 0x80004

  /**
   * The orientation of the camera relative to the sensor coordinate system. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a7731a9056e0d7e36be6b7489ac6738f5">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int LENS_POSE_ROTATION = 524294; // 0x80006

  /**
   * Position of the camera optical center. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a38b480d2695fbe808c364ee838426605">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int LENS_POSE_TRANSLATION = 524295; // 0x80007

  /**
   * The correction coefficients to correct for this camera device's radial and tangential lens
   * distortion. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a190a03664cc7388d4e86bd5c79b946ba">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int LENS_RADIAL_DISTORTION = 524299; // 0x8000b

  /**
   * Current lens status. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a40642bbe3feb5f095f71a2df39b4b34b">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int LENS_STATE = 524297; // 0x80009

  /**
   * Mode of operation for the noise reduction algorithm. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a1ae13ae2d7a6a4a60d7540e426e54826">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int NOISE_REDUCTION_MODE = 655360; // 0xa0000

  /**
   * Specifies the number of pipeline stages the frame went through from when it was exposed to when
   * the final completed result was available to the framework. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ae2938fb92b80c4918e3534e9a5479012">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int REQUEST_PIPELINE_DEPTH = 786441; // 0xc0009

  /**
   * The desired region of the sensor to read out for this capture. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ad44effb20238dd43cb00dc1680057307">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int SCALER_CROP_REGION = 851968; // 0xd0000

  /**
   * A per-frame dynamic black level offset for each of the color filter arrangement (CFA) mosaic
   * channels. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a083b60e47721bb119e4b821d15e0eeee">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int SENSOR_DYNAMIC_BLACK_LEVEL = 917532; // 0xe001c

  /**
   * Maximum raw value output by sensor for this frame. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a77508fe29fb433577a11e6eeb25ac730">Android
   * NDK Docs</a> for details. Access using {@link #getInt(int)}.
   */
  public static final int SENSOR_DYNAMIC_WHITE_LEVEL = 917533; // 0xe001d

  /**
   * Duration each pixel is exposed to light. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a5a4addaae264aa900d7201629a6cea96">Android
   * NDK Docs</a> for details. Access using {@link #getLong(int)}.
   */
  public static final int SENSOR_EXPOSURE_TIME = 917504; // 0xe0000

  /**
   * Duration from start of frame exposure to start of next frame exposure. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ab2b6db4c8552985ccd834c7397b962f8">Android
   * NDK Docs</a> for details. Access using {@link #getLong(int)}.
   */
  public static final int SENSOR_FRAME_DURATION = 917505; // 0xe0001

  /**
   * The worst-case divergence between Bayer green channels. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a273ad97232b4b6554347e6e074035cea">Android
   * NDK Docs</a> for details. Access using {@link #getFloat(int)}.
   */
  public static final int SENSOR_GREEN_SPLIT = 917526; // 0xe0016

  /**
   * The estimated camera neutral color in the native sensor colorspace at the time of capture. See
   * <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a9c480c10989531df4a1c9e0f985c9190">Android
   * NDK Docs</a> for details. Access using {@link #getRationalArray(int)}.
   */
  public static final int SENSOR_NEUTRAL_COLOR_POINT = 917522; // 0xe0012

  /**
   * Noise model coefficients for each CFA mosaic channel. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a3a9e5d0db606334582502e982d112992">Android
   * NDK Docs</a> for details. Access using {@link #getDoubleArray(int)}.
   */
  public static final int SENSOR_NOISE_PROFILE = 917523; // 0xe0013

  /**
   * Duration between the start of first row exposure and the start of last row exposure. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ace86b319af0f1f018c8043f34c7ff134">Android
   * NDK Docs</a> for details. Access using {@link #getLong(int)}.
   */
  public static final int SENSOR_ROLLING_SHUTTER_SKEW = 917530; // 0xe001a

  /**
   * The amount of gain applied to sensor data before processing. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627af00890f7ec7b14df32a2223a835fa044">Android
   * NDK Docs</a> for details. Access using {@link #getInt(int)}.
   */
  public static final int SENSOR_SENSITIVITY = 917506; // 0xe0002

  /**
   * A pixel {@code [R, G_even, G_odd, B]} that supplies the test pattern when
   * ACAMERA_SENSOR_TEST_PATTERN_MODE is SOLID_COLOR. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627af98f47e7213ff699b0fb3cf0e1110c5a">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int SENSOR_TEST_PATTERN_DATA = 917527; // 0xe0017

  /**
   * When enabled, the sensor sends a test pattern instead of doing a real exposure from the camera.
   * See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a59fbccd320d84c2d985dd056f2be1ec3">Android
   * NDK Docs</a> for details. Access using {@link #getInt(int)}.
   */
  public static final int SENSOR_TEST_PATTERN_MODE = 917528; // 0xe0018

  /**
   * Time at start of exposure of first row of the image sensor active array, in nanoseconds. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a1f77ba9480a70bc846cfc1f060ff01a1">Android
   * NDK Docs</a> for details. Access using {@link #getLong(int)}.
   */
  public static final int SENSOR_TIMESTAMP = 917520; // 0xe0010

  /**
   * Quality of lens shading correction applied to the image data. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a40c4fa703a9b28188fd00dd3482f0476">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int SHADING_MODE = 1048576; // 0x100000

  /**
   * Operating mode for the face detector unit. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a8ecd0e7317f4f92cf8aae10110d0d40c">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int STATISTICS_FACE_DETECT_MODE = 1114112; // 0x110000

  /**
   * List of unique IDs for detected faces. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a017123f240e79be2f35b80f9ef0af6b7">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int STATISTICS_FACE_IDS = 1114116; // 0x110004

  /**
   * List of landmarks for detected faces. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aec630c1c5b791726fd7fa4983c8b9dfd">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int STATISTICS_FACE_LANDMARKS = 1114117; // 0x110005

  /**
   * List of the bounding rectangles for detected faces. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ae2592bd4773afdc963644e4255116310">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int STATISTICS_FACE_RECTANGLES = 1114118; // 0x110006

  /**
   * List of the face confidence scores for detected faces See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a14503f7efe94705e40b9128a629ff1e5">Android
   * NDK Docs</a> for details. Access using {@link #getByteArray(int)}.
   */
  public static final int STATISTICS_FACE_SCORES = 1114119; // 0x110007

  /**
   * List of {@code (x, y)} coordinates of hot/defective pixels on the sensor. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a65dedc1121da9e8d01eab56267d969e0">Android
   * NDK Docs</a> for details. Access using {@link #getIntArray(int)}.
   */
  public static final int STATISTICS_HOT_PIXEL_MAP = 1114127; // 0x11000f

  /**
   * Operating mode for hot pixel map generation. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aaf5662ed1894a257406a1620a86c95d1">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int STATISTICS_HOT_PIXEL_MAP_MODE = 1114115; // 0x110003

  /**
   * The shading map is a low-resolution floating-point map that lists the coefficients used to
   * correct for vignetting and color shading, for each Bayer color channel of RAW image data. See
   * <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627abbf59734aabccf4a3805550441c1f1de">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int STATISTICS_LENS_SHADING_MAP = 1114123; // 0x11000b

  /**
   * Whether the camera device will output the lens shading map in output result metadata. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a3099001223536d3939664df33bf0cb8c">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int STATISTICS_LENS_SHADING_MAP_MODE = 1114128; // 0x110010

  /**
   * The camera device estimated scene illumination lighting frequency. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627aa7c95dd585f242dd2496a67b2b7f8db5">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int STATISTICS_SCENE_FLICKER = 1114126; // 0x11000e

  /**
   * The frame number corresponding to the last request with which the output result (metadata +
   * buffers) has been fully synchronized. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627af3842e3e22722ad3b225c4435c947113">Android
   * NDK Docs</a> for details. Access using {@link #getLong(int)}.
   */
  public static final int SYNC_FRAME_NUMBER = 1507328; // 0x170000

  /**
   * Tonemapping / contrast / gamma curve for the blue channel, to use when ACAMERA_TONEMAP_MODE is
   * CONTRAST_CURVE. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a02eb1e6b50ce8d7848e1c336a77dbd83">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int TONEMAP_CURVE_BLUE = 1245184; // 0x130000

  /**
   * Tonemapping / contrast / gamma curve for the green channel, to use when ACAMERA_TONEMAP_MODE is
   * CONTRAST_CURVE. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a788e3f660861599c1219f86bd4c2ee25">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int TONEMAP_CURVE_GREEN = 1245185; // 0x130001

  /**
   * Tonemapping / contrast / gamma curve for the red channel, to use when ACAMERA_TONEMAP_MODE is
   * CONTRAST_CURVE. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a2125b51c76147a5794ceef571a124867">Android
   * NDK Docs</a> for details. Access using {@link #getFloatArray(int)}.
   */
  public static final int TONEMAP_CURVE_RED = 1245186; // 0x130002

  /**
   * Tonemapping curve to use when ACAMERA_TONEMAP_MODE is GAMMA_VALUE See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627af30986b20bbce3d3ce5996f4c59ba09c">Android
   * NDK Docs</a> for details. Access using {@link #getFloat(int)}.
   */
  public static final int TONEMAP_GAMMA = 1245190; // 0x130006

  /**
   * High-level global contrast/gamma/tonemapping control. See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627a0520d079094548ceaa16e96b10891c06">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int TONEMAP_MODE = 1245187; // 0x130003

  /**
   * Tonemapping curve to use when ACAMERA_TONEMAP_MODE is PRESET_CURVE See <a
   * href="https://developer.android.com/ndk/reference/group/camera#group___camera_1gga49cf3e5a3deefe079ad036a8fac14627ad62001f265780b566e95bc7d151075cc">Android
   * NDK Docs</a> for details. Access using {@link #getByte(int)}.
   */
  public static final int TONEMAP_PRESET_CURVE = 1245191; // 0x130007
}
