/*
 * Copyright 2021 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Represents a polygon mesh describing geometry.
 *
 * <p>Obtained by {@link com.google.ar.core.StreetscapeGeometry#getMesh()
 * StreetscapeGeometry#getMesh()}.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Mesh {

  Mesh() {
    // Method contents removed.
  }

  /** Retrieves the number of vertices in this mesh. */
  public int getVertexListSize() {
    // Method contents removed.
  }

  /**
   * Retrieves the vertex coordinate data for this mesh. Each vertex is three float values, stored
   * in XYZ order. The total number of float values in the resulting {@link java.nio.FloatBuffer
   * FloatBuffer} is 3 * {@link com.google.ar.core.Mesh#getVertexListSize()
   * Mesh#getVertexListSize()}.
   *
   * <p>The content of this buffer should not be modified by the caller.
   */
  public java.nio.FloatBuffer getVertexList() {
    // Method contents removed.
  }

  /**
   * Retrieves the number of triangle indices (represented by {@link #getIndexList()}) in this mesh.
   * The indices should always be used as a triangle list, with three indices per triangle. The
   * result can be passed as the {@code count} parameter to {@link
   * android.opengl.GLES20#glDrawElements(int, int, int, java.nio.Buffer)}.
   */
  public int getIndexListSize() {
    // Method contents removed.
  }

  /**
   * Retrieves the triangle data for this mesh in a buffer of length {@link #getIndexListSize()}.
   * Each face is a triplet of indices into the vertices array ({@link #getVertexList()}). The
   * indices should always be used as a triangle list, with three indices per triangle. The result
   * can be passed as the {@code indices} parameter to {@link
   * android.opengl.GLES20#glDrawElements(int, int, int, java.nio.Buffer)}.
   *
   * <p>The content of this buffer should not be modified by the caller.
   */
  public java.nio.IntBuffer getIndexList() {
    // Method contents removed.
  }
}
