/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Describes the current best knowledge of a real-world planar surface.
 *
 * <H2><a name="merging">Merging / Subsumption</a></H2>
 *
 * <p>Two or more planes may be automatically merged into a single parent plane, resulting in each
 * child plane's {@link #getSubsumedBy()} returning the parent plane. A subsumed plane becomes
 * identical to the parent plane, and will continue behaving as if it were independently tracked,
 * for example being included in the output of {@link
 * com.google.ar.core.Frame#getUpdatedTrackables(java.lang.Class)
 * Frame#getUpdatedTrackables(Class)}.
 *
 * <p>{@code Plane}s are hashable and may for example be used as keys in {@code HashMap}s. Subsumed
 * planes are distinct from their parents and siblings.
 *
 * <p><b>Change from Developer Preview 1:</b> Two {@code Plane} objects may refer to the same
 * logical plane detected by the system. Be sure to always use {@link #equals(java.lang.Object)}
 * when comparing them.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Plane implements com.google.ar.core.Trackable {

  Plane() {
    // Method contents removed.
  }

  /** Returns the type of this plane. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Plane.Type getType() {
    // Method contents removed.
  }

  /**
   * If this plane has been subsumed, returns the plane this plane was merged into. In cases where a
   * subsuming plane is itself subsumed, this function will always return the topmost non-subsumed
   * plane.
   *
   * <p><b>See</b> the <a href="#merging">Merging / Subsumption section above</a> for details of the
   * subsumption process.
   *
   * @return the non-subsumed plane that this one has been merged into, or {@code null} if the plane
   *     has not been subsumed.
   */
  @androidx.annotation.Nullable
  public com.google.ar.core.Plane getSubsumedBy() {
    // Method contents removed.
  }

  /**
   * Returns the pose of the center of the detected plane. The pose's transformed +Y axis will be
   * point normal out of the plane, with the +X and +Z axes orienting the extents of the bounding
   * rectangle.
   */
  public com.google.ar.core.Pose getCenterPose() {
    // Method contents removed.
  }

  /**
   * Returns the length of this plane's bounding rectangle measured along the local X-axis of the
   * coordinate space centered on the plane.
   */
  public float getExtentX() {
    // Method contents removed.
  }

  /**
   * Returns the length of this plane's bounding rectangle measured along the local Z-axis of the
   * coordinate frame centered on the plane.
   */
  public float getExtentZ() {
    // Method contents removed.
  }

  /**
   * Returns the 2D vertices of a convex polygon approximating the detected plane, in the form
   * {@code [x1, z1, x2, z2, ...]}. These X-Z values are in the plane's local x-z plane (y=0) and
   * must be transformed by the pose ({@link #getCenterPose()}) to get the boundary in world
   * coordinates.
   */
  @androidx.annotation.NonNull
  public java.nio.FloatBuffer getPolygon() {
    // Method contents removed.
  }

  /**
   * Returns true if the given pose (usually obtained from a HitResult) is in the plane's
   * rectangular extents.
   */
  public boolean isPoseInExtents(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /**
   * Returns true if the given pose (usually obtained from a HitResult) is in the plane's polygon.
   */
  public boolean isPoseInPolygon(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /** Gets this trackable's {@link com.google.ar.core.TrackingState TrackingState}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState() {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor createAnchor(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code Trackable} referencing the same logical
   * trackable as this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public java.util.Collection<com.google.ar.core.Anchor> getAnchors() {
    // Method contents removed.
  }

  /** Simple summary of the normal vector of a plane, for filtering purposes. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum Type {
    /** A horizontal plane facing upward (e.g. floor or tabletop). */
    HORIZONTAL_UPWARD_FACING,
    /** A horizontal plane facing downward (e.g. a ceiling). */
    HORIZONTAL_DOWNWARD_FACING,
    /** A vertical plane (e.g. a wall). */
    VERTICAL;
  }
}
