/*
 * Copyright 2020 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** Describes the current playback status. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum PlaybackStatus {
  /** The session is not playing back an MP4 dataset file. */
  NONE,
  /** Playback is in process without issues. */
  OK,
  /** Playback has stopped due to an error. */
  IO_ERROR,
  /** Playback has finished successfully. */
  FINISHED;
}
