/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Represents a point in space that ARCore is tracking. These objects are created as a side-effect
 * of {@link com.google.ar.core.Session#createAnchor(com.google.ar.core.Pose)
 * Session#createAnchor(Pose)} or when {@link com.google.ar.core.Frame#hitTest(float,float)
 * Frame#hitTest(float, float)} returns results against a point cloud.
 *
 * <p>Note: Two {@code Point} objects may refer to the same logical point managed by ARCore. Be sure
 * to always use {@link #equals(java.lang.Object)} when comparing them.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Point implements com.google.ar.core.Trackable {

  Point() {
    // Method contents removed.
  }

  /**
   * Returns the pose of the point for {@link com.google.ar.core.Point Point}s created by {@link
   * com.google.ar.core.Frame#hitTest(float,float) Frame#hitTest(float, float)}.
   *
   * <ul>
   *   <li>If {@link com.google.ar.core.Point.OrientationMode OrientationMode} is {@link
   *       com.google.ar.core.Point.OrientationMode#ESTIMATED_SURFACE_NORMAL
   *       OrientationMode#ESTIMATED_SURFACE_NORMAL}, then the orientation is such that X+ is
   *       perpendicular to the cast ray and parallel to the physical surface centered around the
   *       hit test, Y+ points along the estimated surface normal, and Z+ points roughly toward the
   *       user's device.
   *   <li>If {@link com.google.ar.core.Point.OrientationMode OrientationMode} is {@link
   *       com.google.ar.core.Point.OrientationMode#ESTIMATED_SURFACE_NORMAL
   *       OrientationMode#ESTIMATED_SURFACE_NORMAL}, then the orientation is identity or close to
   *       identity.
   * </ul>
   */
  public com.google.ar.core.Pose getPose() {
    // Method contents removed.
  }

  /**
   * Returns the OrientationMode {@link com.google.ar.core.Point.OrientationMode OrientationMode} of
   * the point.
   *
   * @return {@link com.google.ar.core.Point.OrientationMode OrientationMode}
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Point.OrientationMode getOrientationMode() {
    // Method contents removed.
  }

  /** Gets this trackable's {@link com.google.ar.core.TrackingState TrackingState}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState() {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor createAnchor(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code Trackable} referencing the same logical
   * trackable as this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public java.util.Collection<com.google.ar.core.Anchor> getAnchors() {
    // Method contents removed.
  }

  /** Indicates the point orientation mode. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum OrientationMode {
    /** Point orientation is initialized to identity but may adjust slightly over time. */
    INITIALIZED_TO_IDENTITY,
    /**
     * Point orientation will follow the behavior described in {@link
     * com.google.ar.core.HitResult#getHitPose() HitResult#getHitPose()}.
     */
    ESTIMATED_SURFACE_NORMAL;
  }
}
