/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Contains a set of observed 3D points and confidence values. This class implements {@link
 * java.io.Closeable Closeable} and usually should be used in a Java try-with-resources or Kotlin
 * {@code use} block, for example:
 *
 * <pre>{@code
 * Frame frame = session.update();
 * ...
 * // Automatically releases point cloud resources at end of try block.
 * try (PointCloud pointCloud = frame.acquirePointCloud()) {
 *   // Access point cloud data.
 * }
 * }</pre>
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class PointCloud implements java.io.Closeable {

  PointCloud() {
    // Method contents removed.
  }

  /**
   * Release PointCloud's resources back to ARCore. If too many point clouds are held, additional
   * calls to {@link com.google.ar.core.Frame#acquirePointCloud() Frame#acquirePointCloud()} will
   * fail. Calling this method may invalidate any buffer previously returned by {@link #getPoints()}
   * or {@link #getIds()}.
   *
   * <p>This method will be called automatically by {@link #close()} if the object is acquired in a
   * Java try-with-resources initializer or Kotlin {@code use} statement.
   *
   * @see com.google.ar.core.Frame#acquirePointCloud()
   */
  public void release() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /**
   * Returns a buffer of point coordinates and confidence values.
   *
   * <p>Each point is represented by four consecutive values in the buffer; first the X, Y, Z
   * position coordinates, followed by a confidence value. This is the same format as described in
   * {@link android.graphics.ImageFormat#DEPTH_POINT_CLOUD}.
   *
   * <p>Point locations are in the world coordinate space, consistent with the camera position for
   * the frame that provided the point cloud.
   */
  public java.nio.FloatBuffer getPoints() {
    // Method contents removed.
  }

  /**
   * Retrieves a buffer of point cloud point IDs.
   *
   * <p>Each point has a unique identifier (within a session) that is persistent across frames. That
   * is, if a point from point cloud 1 has the same id as the point from point cloud 2, then it
   * represents the same point in space.
   */
  public java.nio.IntBuffer getIds() {
    // Method contents removed.
  }

  /**
   * Returns the timestamp in nanoseconds when this point cloud was observed. This timestamp uses
   * the same time base as {@link com.google.ar.core.Frame#getTimestamp() Frame#getTimestamp()}.
   *
   * @see com.google.ar.core.Frame#getTimestamp()
   */
  public long getTimestamp() {
    // Method contents removed.
  }

  /** Release PointCloud's resources back to ARCore. Calls {@link #release()}. */
  public void close() {
    // Method contents removed.
  }
}
