/*
 * Copyright 2019 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/** Configuration related to session recording. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class RecordingConfig {

  public RecordingConfig(com.google.ar.core.Session session) {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /**
   * Sets the file path to save an MP4 dataset file for the recording.
   *
   * <p>The app must have permission to write to {@code mp4DatasetFilePath}. See <a
   * href="https://developer.android.com/about/versions/11/privacy/storage">Storage updates in
   * Android 11</a> for potential limitations with file paths on Android 11 and later.
   *
   * @deprecated Please use {@link #setMp4DatasetUri(android.net.Uri)} to set the recording
   *     location.
   */
  @Deprecated
  @androidx.annotation.NonNull
  public com.google.ar.core.RecordingConfig setMp4DatasetFilePath(
      java.lang.String mp4DatasetFilePath) {
    // Method contents removed.
  }

  /**
   * Set MP4 recording dataset {@link android.net.Uri}.
   *
   * <p>This will override any output set by {@link #setMp4DatasetFilePath(java.lang.String)}.
   *
   * <p>The {@link android.net.Uri Uri} must represent a resource that supports {@code lseek}.
   * Otherwise, {@link com.google.ar.core.Session#startRecording(com.google.ar.core.RecordingConfig)
   * } will throw an {@link java.lang.IllegalArgumentException IllegalArgumentException} when
   * called.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.RecordingConfig setMp4DatasetUri(android.net.Uri mp4DatasetUri) {
    // Method contents removed.
  }

  /**
   * Gets the file path to save an MP4 dataset file for the recording.
   *
   * <p>This will return {@code null} if the output was set with {@link
   * #setMp4DatasetUri(android.net.Uri)}.
   *
   * @deprecated Please use {@link #getMp4DatasetUri()} to get the recording location.
   */
  @Deprecated
  @androidx.annotation.Nullable
  public java.lang.String getMp4DatasetFilePath() {
    // Method contents removed.
  }

  /**
   * Gets the {@link android.net.Uri Uri} that the MP4 dataset will be recorded to.
   *
   * <p>This will return {@code null} if the output was set with {@link
   * #setMp4DatasetFilePath(java.lang.String)}.
   */
  @androidx.annotation.Nullable
  public android.net.Uri getMp4DatasetUri() {
    // Method contents removed.
  }

  /** Specify whether recording should stop automatically when the ARCore session is paused. */
  @androidx.annotation.NonNull
  public com.google.ar.core.RecordingConfig setAutoStopOnPause(boolean enable) {
    // Method contents removed.
  }

  /**
   * Gets the setting that indicates whether the recording should stop automatically when the ARCore
   * session is paused.
   */
  public boolean getAutoStopOnPause() {
    // Method contents removed.
  }

  /**
   * Specify the clockwise rotation in degrees that should be applied to the recorded image (0, 90,
   * 180, or 270).
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.RecordingConfig setRecordingRotation(int rotation) {
    // Method contents removed.
  }

  /**
   * Get the clockwise rotation in degrees that should be applied to the recorded image (0, 90, 180,
   * or 270, or -1 for unspecified).
   */
  public int getRecordingRotation() {
    // Method contents removed.
  }

  /** Configures and adds a {@link com.google.ar.core.Track Track} for recording. */
  @androidx.annotation.NonNull
  public com.google.ar.core.RecordingConfig addTrack(com.google.ar.core.Track track) {
    // Method contents removed.
  }
}
