/*
 * Copyright 2023 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Handle to an async operation launched by {@link
 * com.google.ar.core.Earth#resolveAnchorOnRooftopAsync(double,double,double,float,float,float,float,java.util.function.BiConsumer)
 * Earth#resolveAnchorOnRooftopAsync(double, double, double, float, float, float, float,
 * BiConsumer)}. See the <a
 * href="https://developers.google.com/ar/develop/geospatial/java/anchors#rooftop-anchors">Rooftop
 * anchors developer guide</a> for more information.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ResolveAnchorOnRooftopFuture implements com.google.ar.core.Future {

  ResolveAnchorOnRooftopFuture() {
    // Method contents removed.
  }

  /**
   * Returns the resolved anchor, when {@link com.google.ar.core.Future#getState()
   * Future#getState()} returns {@link com.google.ar.core.FutureState#DONE FutureState#DONE} and
   * {@link #getResultRooftopAnchorState()} returns {@link
   * com.google.ar.core.Anchor.RooftopAnchorState#SUCCESS Anchor.RooftopAnchorState#SUCCESS}.
   * Otherwise, returns {@code null}.
   */
  @androidx.annotation.Nullable
  public com.google.ar.core.Anchor getResultAnchor() {
    // Method contents removed.
  }

  /**
   * Returns the result status of the resolving operation, when {@link
   * com.google.ar.core.Future#getState() Future#getState()} returns {@link
   * com.google.ar.core.FutureState#DONE FutureState#DONE}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor.RooftopAnchorState getResultRooftopAnchorState() {
    // Method contents removed.
  }

  public boolean cancel() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.FutureState getState() {
    // Method contents removed.
  }
}
