/*
 * Copyright 2023 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Handle to an async operation launched by {@link
 * com.google.ar.core.Earth#resolveAnchorOnTerrainAsync(double,double,double,float,float,float,float,java.util.function.BiConsumer)
 * Earth#resolveAnchorOnTerrainAsync(double, double, double, float, float, float, float,
 * BiConsumer)}. See the <a
 * href="https://developers.google.com/ar/develop/geospatial/java/anchors#terrain-anchors">Terrain
 * anchors developer guide</a> for more information.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ResolveAnchorOnTerrainFuture implements com.google.ar.core.Future {

  ResolveAnchorOnTerrainFuture() {
    // Method contents removed.
  }

  /**
   * Returns the resolved anchor, when {@link com.google.ar.core.Future#getState()
   * Future#getState()} returns {@link com.google.ar.core.FutureState#DONE FutureState#DONE} and
   * {@link #getResultTerrainAnchorState()} returns {@link
   * com.google.ar.core.Anchor.TerrainAnchorState#SUCCESS Anchor.TerrainAnchorState#SUCCESS}.
   * Otherwise, returns {@code null}.
   */
  @androidx.annotation.Nullable
  public com.google.ar.core.Anchor getResultAnchor() {
    // Method contents removed.
  }

  /**
   * Returns the result status of the resolving operation, when {@link
   * com.google.ar.core.Future#getState() Future#getState()} returns {@link
   * com.google.ar.core.FutureState#DONE FutureState#DONE}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor.TerrainAnchorState getResultTerrainAnchorState() {
    // Method contents removed.
  }

  public boolean cancel() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.FutureState getState() {
    // Method contents removed.
  }
}
