/*
 * Copyright 2023 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Handle to an async operation launched by {@link
 * com.google.ar.core.Session#resolveCloudAnchorAsync(java.lang.String,java.util.function.BiConsumer)
 * Session#resolveCloudAnchorAsync(String, BiConsumer)}. See the <a
 * href="https://developers.google.com/ar/develop/java/cloud-anchors/developer-guide">Cloud Anchors
 * developer guide</a> for more information.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ResolveCloudAnchorFuture implements com.google.ar.core.Future {

  ResolveCloudAnchorFuture() {
    // Method contents removed.
  }

  /**
   * Returns the resolved anchor, when {@link com.google.ar.core.Future#getState()
   * Future#getState()} returns {@link com.google.ar.core.FutureState#DONE FutureState#DONE} and
   * {@link #getResultCloudAnchorState()} returns {@link
   * com.google.ar.core.Anchor.CloudAnchorState#SUCCESS Anchor.CloudAnchorState#SUCCESS}. Otherwise,
   * returns {@code null}.
   */
  @androidx.annotation.Nullable
  public com.google.ar.core.Anchor getResultAnchor() {
    // Method contents removed.
  }

  /**
   * Returns the result status of the resolving operation, when {@link
   * com.google.ar.core.Future#getState() Future#getState()} returns {@link
   * com.google.ar.core.FutureState#DONE FutureState#DONE}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor.CloudAnchorState getResultCloudAnchorState() {
    // Method contents removed.
  }

  public boolean cancel() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.FutureState getState() {
    // Method contents removed.
  }
}
