/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Defines geometry such as terrain, buildings, or other structures obtained from the Streetscape
 * Geometry API. See the <a
 * href="https://developers.google.com/ar/develop/java/geospatial/streetscape-geometry">Streetscape
 * Geometry Developer Guide</a> for additional information.
 *
 * <p>Obtained from a call to {@link com.google.ar.core.Session#getAllTrackables(java.lang.Class)
 * Session#getAllTrackables(Class)} or {@link
 * com.google.ar.core.Frame#getUpdatedTrackables(java.lang.Class) }} when {@link
 * com.google.ar.core.Config.StreetscapeGeometryMode Config.StreetscapeGeometryMode} is set to
 * {@link com.google.ar.core.Config.StreetscapeGeometryMode#ENABLED } and {@link
 * com.google.ar.core.Config.GeospatialMode Config.GeospatialMode} is set to {@link
 * com.google.ar.core.Config.GeospatialMode#ENABLED }.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class StreetscapeGeometry implements com.google.ar.core.Trackable {

  StreetscapeGeometry() {
    // Method contents removed.
  }

  /**
   * Returns the origin pose of the geometry. This pose should be applied to all the points in the
   * geometry from {@link #getMesh()}.
   */
  public com.google.ar.core.Pose getMeshPose() {
    // Method contents removed.
  }

  /**
   * Obtain a polygon {@link com.google.ar.core.Mesh Mesh} that corresponds to this geometry. A
   * {@link com.google.ar.core.Mesh Mesh} describes the geometry as a collection of polygons, which
   * should be transformed by {@link #getMeshPose()}.
   */
  public com.google.ar.core.Mesh getMesh() {
    // Method contents removed.
  }

  /**
   * Obtain the {@link com.google.ar.core.StreetscapeGeometry.Type StreetscapeGeometry.Type}
   * corrosponding to this geometry.
   */
  public com.google.ar.core.StreetscapeGeometry.Type getType() {
    // Method contents removed.
  }

  /**
   * Obtain the {@link com.google.ar.core.StreetscapeGeometry.Quality StreetscapeGeometry.Quality}
   * corrosponding to this geometry.
   */
  public com.google.ar.core.StreetscapeGeometry.Quality getQuality() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /** Gets this trackable's {@link com.google.ar.core.TrackingState TrackingState}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState() {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor createAnchor(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code Trackable} referencing the same logical
   * trackable as this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public java.util.Collection<com.google.ar.core.Anchor> getAnchors() {
    // Method contents removed.
  }

  /**
   * Describes the quality of the mesh data. The values correspond to the levels of detail (LOD)
   * defined by the <a href="https://portal.ogc.org/files/?artifact_id=16675">CityGML 2.0
   * standard</a>.
   *
   * <p>Obtained by {@link #getQuality()}.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum Quality {
    /**
     * The quality of the geometry is not defined, e.g. when the {@link
     * com.google.ar.core.StreetscapeGeometry.Type StreetscapeGeometry.Type} is {@link
     * com.google.ar.core.StreetscapeGeometry.Type#TERRAIN StreetscapeGeometry.Type#TERRAIN}.
     */
    NONE,
    /**
     * The {@link com.google.ar.core.StreetscapeGeometry.Type#BUILDING
     * StreetscapeGeometry.Type#BUILDING} geometry is the building footprint extruded up to a single
     * flat top. The building contains empty space above any angled roofs.
     */
    BUILDING_LOD_1,
    /**
     * The {@link com.google.ar.core.StreetscapeGeometry.Type#BUILDING
     * StreetscapeGeometry.Type#BUILDING} geometry is the building footprint with a rough heightmap.
     * The geometry will closely follow simple angled roofs. Chimneys and roof vents on top of roofs
     * will poke outside of the mesh.
     */
    BUILDING_LOD_2;
  }

  /**
   * Describes the type of a Streetscape Geometry.
   *
   * <p>Obtained by {@link #getType()}.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum Type {
    /** This geometry represents the ground or floor. */
    TERRAIN,
    /** This geometry represents a building. */
    BUILDING;
  }
}
