/*
 * Copyright 2021 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Data that was recorded to a track. This data can be queried via {@link
 * com.google.ar.core.Frame#getUpdatedTrackData Frame#getUpdatedTrackData} during playback.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TrackData {

  TrackData() {
    // Method contents removed.
  }

  /**
   * Retrieves the timestamp in nanoseconds of the frame this TrackData was recorded on via {@link
   * com.google.ar.core.Frame#recordTrackData(UUID,java.nio.ByteBuffer) }. This timestamp is equal
   * to the result of {@link com.google.ar.core.Frame#getTimestamp() } on the frame when {@link
   * com.google.ar.core.Frame#recordTrackData(UUID,java.nio.ByteBuffer) Frame#recordTrackData(UUID,
   * ByteBuffer)} was called.
   */
  public long getFrameTimestamp() {
    // Method contents removed.
  }

  /**
   * Get the byte data recorded using {@link
   * com.google.ar.core.Frame#recordTrackData(UUID,java.nio.ByteBuffer) Frame#recordTrackData(UUID,
   * ByteBuffer)}. The ByteBuffer's limit and capacity with both be set to the limit of the
   * ByteBuffer passed in to {@link
   * com.google.ar.core.Frame#recordTrackData(UUID,java.nio.ByteBuffer) Frame#recordTrackData(UUID,
   * ByteBuffer)} when this was recorded.
   */
  public java.nio.ByteBuffer getData() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /** Release the native resources for this object. */
  public void close() {
    // Method contents removed.
  }
}
