/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** A Trackable is something that ARCore can track and that Anchors can be attached to. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Trackable {

  /**
   * Gets the TrackingState of this Trackable.
   *
   * <p>Note: Starting in ARCore 1.12, changing the active camera config using {@link
   * com.google.ar.core.Session#setCameraConfig(com.google.ar.core.CameraConfig) } may cause the
   * tracking state on certain devices to become permanently PAUSED. For consistent behavior across
   * all supported devices, release any previously created trackables when setting a new camera
   * config.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState();

  /**
   * Creates an anchor that is attached to this trackable, using the given initial pose in the world
   * coordinate space. The type of trackable will determine the semantics of attachment and how the
   * anchor's pose will be updated to maintain this relationship. Note that the relative offset
   * between the pose of multiple anchors attached to a trackable may adjust slightly over time as
   * ARCore updates its model of the world.
   *
   * @throws com.google.ar.core.exceptions.NotTrackingException if the trackable's tracking state
   *     was not {@link com.google.ar.core.TrackingState#TRACKING TrackingState#TRACKING}
   * @throws com.google.ar.core.exceptions.SessionPausedException if the session had been paused.
   * @throws com.google.ar.core.exceptions.ResourceExhaustedException if too many anchors exist.
   * @throws java.lang.IllegalStateException if this trackable doesn't support anchors.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor createAnchor(com.google.ar.core.Pose pose);

  /** Gets the Anchors attached to this trackable. */
  @androidx.annotation.NonNull
  public java.util.Collection<com.google.ar.core.Anchor> getAnchors();
}
