/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** Describes the tracking state of the Trackable. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum TrackingState {
  /** The Trackable is currently tracked and its pose is current. */
  TRACKING,
  /**
   * ARCore has paused tracking this instance, but may resume tracking it in the future. This can
   * happen if device tracking is lost, or if the user enters a new space, or if the Session is
   * currently paused. When in this state the properties of the instance may be wildly inaccurate
   * and should generally not be used.
   */
  PAUSED,
  /** ARCore has stopped tracking this Trackable and will never resume tracking it. */
  STOPPED;
}
