/*
 * Copyright 2022 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Asynchronous result of calling {@link
 * com.google.ar.core.Session#checkVpsAvailabilityAsync(double,double,Consumer)
 * Session#checkVpsAvailabilityAsync(double, double, Consumer)}. Obtained by {@link
 * com.google.ar.core.VpsAvailabilityFuture#getResult() VpsAvailabilityFuture#getResult()}.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum VpsAvailability {
  /**
   * The request to the remote service is not yet completed, so the availability is not yet known.
   */
  UNKNOWN,
  /** VPS is available at the requested location. */
  AVAILABLE,
  /** VPS is not available at the requested location. */
  UNAVAILABLE,
  /** An internal error occurred while determining availability. */
  ERROR_INTERNAL,
  /** The external service could not be reached due to a network connection error. */
  ERROR_NETWORK_CONNECTION,
  /**
   * An authorization error occurred when communicating with the Google Cloud ARCore API. See <a
   * href="https://developers.google.com/ar/develop/java/geospatial/enable">Enable the Geospatial
   * API</a> for troubleshooting steps.
   */
  ERROR_NOT_AUTHORIZED,
  /** Too many requests were sent. */
  ERROR_RESOURCE_EXHAUSTED;
}
