/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core.exceptions;

/**
 * The Android precise location permission ({@code ACCESS_FINE_LOCATION}) is required, but has not
 * been granted prior to calling {@link
 * com.google.ar.core.Session#configure(com.google.ar.core.Config)} when {@link
 * com.google.ar.core.Config.GeospatialMode} is set to {@link
 * com.google.ar.core.Config.GeospatialMode#ENABLED}.
 *
 * <p>See <a
 * href="https://developer.android.com/training/location/permissions#request-location-access-runtime">Android
 * documentation on Request location access at runtime</a> for more information on how to request
 * the {@code ACCESS_FINE_LOCATION} permission.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class FineLocationPermissionNotGrantedException extends java.lang.SecurityException {

  public FineLocationPermissionNotGrantedException() {
    // Method contents removed.
  }

  public FineLocationPermissionNotGrantedException(java.lang.String message) {
    // Method contents removed.
  }
}
