/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core.exceptions;

/**
 * The <a href="https://developers.google.com/android/guides/setup#declare-dependencies">Fused
 * Location Provider for Android library</a> is required, but wasn't found in the client app's
 * binary prior to calling {@link com.google.ar.core.Session#configure(com.google.ar.core.Config)}
 * when {@link com.google.ar.core.Config.GeospatialMode} is set to {@link
 * com.google.ar.core.Config.GeospatialMode#ENABLED}.
 *
 * <p>Ensure that your app <a
 * href="https://developers.google.com/ar/develop/java/geospatial/developer-guide#include-required-libraries">includes
 * the Fused Location Provider of Android library</a>, and that your app's <a
 * href="https://developers.google.com/ar/develop/java/geospatial/developer-guide#include-required-proguard-rules">ProGuard
 * rules are correctly set up for the Geospatial API</a>.
 *
 * <p>When building your app, check the resulting binary with the <a
 * href="https://developer.android.com/studio/debug/apk-analyzer">APK Analyzer</a>, and ensure that
 * the built application binary includes the {@code com.google.android.gms.location} package, and
 * that its contents are not renamed or minified.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class GooglePlayServicesLocationLibraryNotLinkedException
    extends com.google.ar.core.exceptions.UnsupportedConfigurationException {

  public GooglePlayServicesLocationLibraryNotLinkedException() {
    // Method contents removed.
  }

  public GooglePlayServicesLocationLibraryNotLinkedException(java.lang.String message) {
    // Method contents removed.
  }
}
