/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core.exceptions;

/**
 * Acquire failed because there are too many objects already acquired. For example, the application
 * may acquire up to N point clouds. N is determined by available resources, and is usually small
 * (for example, 8). If the application tries to acquire N+1 point clouds without releasing the
 * previously acquired ones, it will get this error.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ResourceExhaustedException extends java.lang.RuntimeException {

  public ResourceExhaustedException() {
    // Method contents removed.
  }

  public ResourceExhaustedException(java.lang.String message) {
    // Method contents removed.
  }
}
