/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import com.google.ar.core.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;

public class AugmentedImageDatabase {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    public static AugmentedImageDatabase deserialize(Session session, InputStream inputStream) throws IOException {
        Session session2;
        ByteBuffer byteBuffer = AugmentedImageDatabase.loadDirectByteBuffer(inputStream);
        long l2 = AugmentedImageDatabase.nativeDeserialize(session2.nativeWrapperHandle, byteBuffer);
        return new AugmentedImageDatabase(session2, l2);
    }

    /*
     * WARNING - void declaration
     */
    public AugmentedImageDatabase(Session session) {
        void var1_1;
        void v0 = var1_1;
        this((Session)v0, AugmentedImageDatabase.nativeCreate(v0.nativeWrapperHandle));
    }

    /*
     * WARNING - void declaration
     */
    AugmentedImageDatabase(Session session, long nativeHandle) {
        void var2_2;
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = var2_2;
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    /*
     * WARNING - void declaration
     */
    public int addImage(String name, Bitmap bitmap) {
        void var1_1;
        void var2_2;
        AugmentedImageDatabase augmentedImageDatabase = this;
        ByteBuffer byteBuffer = AugmentedImageDatabase.convertBitmapToGrayscaleDirectBuffer((Bitmap)var2_2);
        int n2 = var2_2.getWidth();
        return augmentedImageDatabase.nativeAddImage(augmentedImageDatabase.session.nativeWrapperHandle, this.nativeHandle, (String)var1_1, byteBuffer, var2_2.getWidth(), var2_2.getHeight(), n2);
    }

    /*
     * WARNING - void declaration
     */
    public int addImage(String name, Bitmap bitmap, float widthInMeters) {
        void var3_3;
        void var1_1;
        void var2_2;
        AugmentedImageDatabase augmentedImageDatabase = this;
        ByteBuffer byteBuffer = AugmentedImageDatabase.convertBitmapToGrayscaleDirectBuffer((Bitmap)var2_2);
        int n2 = var2_2.getWidth();
        return augmentedImageDatabase.nativeAddImageWithPhysicalSize(augmentedImageDatabase.session.nativeWrapperHandle, this.nativeHandle, (String)var1_1, byteBuffer, var2_2.getWidth(), var2_2.getHeight(), n2, (float)var3_3);
    }

    public int getNumImages() {
        AugmentedImageDatabase augmentedImageDatabase = this;
        return augmentedImageDatabase.nativeGetNumImages(augmentedImageDatabase.session.nativeWrapperHandle, this.nativeHandle);
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(OutputStream outputStream) throws IOException {
        void var1_1;
        AugmentedImageDatabase augmentedImageDatabase = this_;
        ByteBuffer this_ = augmentedImageDatabase.nativeSerialize(augmentedImageDatabase.session.nativeWrapperHandle, ((AugmentedImageDatabase)((Object)this_)).nativeHandle);
        Channels.newChannel((OutputStream)var1_1).write(this_);
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            AugmentedImageDatabase augmentedImageDatabase = this;
            augmentedImageDatabase.nativeReleaseDatabase(augmentedImageDatabase.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    static ByteBuffer convertBitmapToGrayscaleDirectBuffer(Bitmap bitmap) {
        Bitmap bitmap2;
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter colorMatrixColorFilter = new ColorMatrixColorFilter(colorMatrix);
        ColorMatrix colorMatrix2 = colorMatrix;
        colorMatrix2();
        colorMatrix2.setColorFilter((ColorFilter)colorMatrixColorFilter);
        Bitmap bitmap3 = Bitmap.createBitmap((int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap3);
        canvas.drawBitmap(bitmap2, 0.0f, 0.0f, (Paint)colorMatrix);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bitmap2.getWidth() * bitmap2.getHeight());
        for (int i2 = 0; i2 < bitmap2.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bitmap2.getWidth(); ++i3) {
                byte by = (byte)Color.red((int)bitmap3.getPixel(i3, i2));
                byteBuffer.put(i2 * bitmap2.getWidth() + i3, by);
            }
        }
        return byteBuffer;
    }

    private static ByteBuffer loadDirectByteBuffer(InputStream is) throws IOException {
        int n2;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.max(32, ((InputStream)object).available()));
        byte[] byArray = new byte[8192];
        while ((n2 = ((InputStream)object).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        object = byteArrayOutputStream.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(((Object)object).length);
        byteBuffer.put((byte[])object);
        return byteBuffer;
    }

    private static native long nativeCreate(long var0);

    private static native long nativeDeserialize(long var0, ByteBuffer var2);

    private native int nativeAddImage(long var1, long var3, String var5, ByteBuffer var6, int var7, int var8, int var9);

    private native int nativeAddImageWithPhysicalSize(long var1, long var3, String var5, ByteBuffer var6, int var7, int var8, int var9, float var10);

    private native ByteBuffer nativeSerialize(long var1, long var3);

    private native int nativeGetNumImages(long var1, long var3);

    private native void nativeReleaseDatabase(long var1, long var3);
}

