/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.CameraIntrinsics;
import com.google.ar.core.Frame;
import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackingFailureReason;
import com.google.ar.core.TrackingState;

public class Camera {
    private static final String TAG = "ARCore-Camera";
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    /*
     * WARNING - void declaration
     */
    Camera(Session session, Frame frame) {
        void var2_2;
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = Camera.nativeAcquireCamera(var1_1.nativeWrapperHandle, var2_2.nativeHandle);
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected Camera() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (!(obj instanceof Camera)) {
            return false;
        }
        return ((Camera)var1_1).nativeHandle == this.nativeHandle;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeHandle).hashCode();
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            Camera.nativeReleaseCamera(this.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    @NonNull
    public TrackingState getTrackingState() {
        Camera camera = this;
        return TrackingState.forNumber(camera.nativeGetTrackingState(camera.session.nativeWrapperHandle, this.nativeHandle));
    }

    @NonNull
    public TrackingFailureReason getTrackingFailureReason() {
        Camera camera = this;
        return TrackingFailureReason.forNumber(camera.nativeGetTrackingFailureReason(camera.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Pose getPose() {
        Camera camera = this;
        return camera.nativeGetPose(camera.session.nativeWrapperHandle, this.nativeHandle);
    }

    public Pose getDisplayOrientedPose() {
        Camera camera = this;
        return camera.nativeDisplayOrientedPose(camera.session.nativeWrapperHandle, this.nativeHandle);
    }

    /*
     * WARNING - void declaration
     */
    public void getViewMatrix(float[] viewMatrix, int offset) {
        void var2_2;
        void var1_1;
        Camera camera = this;
        camera.nativeGetViewMatrix(camera.session.nativeWrapperHandle, this.nativeHandle, (float[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void getProjectionMatrix(float[] dest, int offset, float near, float far) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Camera camera = this;
        camera.nativeGetProjectionMatrix(camera.session.nativeWrapperHandle, this.nativeHandle, (float[])var1_1, (int)var2_2, (float)var3_3, (float)var4_4);
    }

    public CameraIntrinsics getImageIntrinsics() {
        Camera camera = this;
        long l2 = camera.nativeCreateCameraIntrinsics(camera.session.nativeWrapperHandle);
        Session session = this.session;
        CameraIntrinsics cameraIntrinsics = new CameraIntrinsics(l2, session);
        Camera camera2 = this;
        camera2.nativeGetImageIntrinsics(camera2.session.nativeWrapperHandle, this.nativeHandle, cameraIntrinsics.nativeHandle);
        return cameraIntrinsics;
    }

    public CameraIntrinsics getTextureIntrinsics() {
        Camera camera = this;
        long l2 = camera.nativeCreateCameraIntrinsics(camera.session.nativeWrapperHandle);
        Session session = this.session;
        CameraIntrinsics cameraIntrinsics = new CameraIntrinsics(l2, session);
        Camera camera2 = this;
        camera2.nativeGetTextureIntrinsics(camera2.session.nativeWrapperHandle, this.nativeHandle, cameraIntrinsics.nativeHandle);
        return cameraIntrinsics;
    }

    private static native long nativeAcquireCamera(long var0, long var2);

    private static native void nativeReleaseCamera(long var0, long var2);

    private native int nativeGetTrackingState(long var1, long var3);

    private native int nativeGetTrackingFailureReason(long var1, long var3);

    private native Pose nativeGetPose(long var1, long var3);

    private native Pose nativeDisplayOrientedPose(long var1, long var3);

    private native void nativeGetViewMatrix(long var1, long var3, float[] var5, int var6);

    private native void nativeGetProjectionMatrix(long var1, long var3, float[] var5, int var6, float var7, float var8);

    private native long nativeCreateCameraIntrinsics(long var1);

    private native void nativeGetImageIntrinsics(long var1, long var3, long var5);

    private native void nativeGetTextureIntrinsics(long var1, long var3, long var5);
}

