/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.AugmentedImageDatabase;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.p;

public class Config {
    private static final String TAG = "ARCore-Config";
    final Session session;
    final long nativeSymbolTableHandle;
    long nativeHandle;

    /*
     * WARNING - void declaration
     */
    public Config(Session session) {
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = Config.nativeCreate(var1_1.nativeWrapperHandle);
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    /*
     * WARNING - void declaration
     */
    Config(Session session, long nativeHandle) {
        void var2_2;
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = var2_2;
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected Config() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    @NonNull
    public LightEstimationMode getLightEstimationMode() {
        Config config = this;
        return LightEstimationMode.forNumber(config.nativeGetLightEstimationMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setLightEstimationMode(LightEstimationMode lightEstimationMode) {
        void var1_1;
        Config config = this;
        config.nativeSetLightEstimationMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public PlaneFindingMode getPlaneFindingMode() {
        Config config = this;
        return PlaneFindingMode.forNumber(config.nativeGetPlaneFindingMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setPlaneFindingMode(PlaneFindingMode planeFindingMode) {
        void var1_1;
        Config config = this;
        config.nativeSetPlaneFindingMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public UpdateMode getUpdateMode() {
        Config config = this;
        return UpdateMode.forNumber(config.nativeGetUpdateMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setUpdateMode(UpdateMode updateMode) {
        void var1_1;
        Config config = this;
        config.nativeSetUpdateMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setCloudAnchorMode(CloudAnchorMode cloudAnchorMode) {
        void var1_1;
        Config config = this;
        config.nativeSetCloudAnchorMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public CloudAnchorMode getCloudAnchorMode() {
        Config config = this;
        return CloudAnchorMode.forNumber(config.nativeGetCloudAnchorMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public Config setAugmentedImageDatabase(AugmentedImageDatabase augmentedImageDatabase) {
        void var1_1;
        long l2 = this.session.nativeWrapperHandle;
        long l3 = this.nativeHandle;
        long l4 = var1_1 == null ? 0L : var1_1.nativeHandle;
        this.nativeSetAugmentedImageDatabase(l2, l3, l4);
        return this;
    }

    @NonNull
    public AugmentedImageDatabase getAugmentedImageDatabase() {
        Config config = this;
        long l2 = config.nativeGetAugmentedImageDatabase(config.session.nativeWrapperHandle, this.nativeHandle);
        return new AugmentedImageDatabase(this.session, l2);
    }

    @NonNull
    public AugmentedFaceMode getAugmentedFaceMode() {
        Config config = this;
        return AugmentedFaceMode.forNumber(config.nativeGetAugmentedFaceMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setAugmentedFaceMode(AugmentedFaceMode augmentedFaceMode) {
        void var1_1;
        Config config = this;
        config.nativeSetAugmentedFaceMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public FocusMode getFocusMode() {
        Config config = this;
        return FocusMode.forNumber(config.nativeGetFocusMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setFocusMode(FocusMode focusMode) {
        void var1_1;
        Config config = this;
        config.nativeSetFocusMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public GeospatialMode getGeospatialMode() {
        Session session = this.session;
        Config config = this;
        return GeospatialMode.forNumber(config.nativeGetGeospatialMode(config.nativeSymbolTableHandle, session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setGeospatialMode(GeospatialMode geospatialMode) {
        void var1_1;
        Session session = this.session;
        Config config = this;
        config.nativeSetGeospatialMode(config.nativeSymbolTableHandle, session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public StreetscapeGeometryMode getStreetscapeGeometryMode() {
        Session session = this.session;
        Config config = this;
        return StreetscapeGeometryMode.forNumber(config.nativeGetStreetscapeGeometryMode(config.nativeSymbolTableHandle, session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setStreetscapeGeometryMode(StreetscapeGeometryMode streetscapeGeometryMode) {
        void var1_1;
        Session session = this.session;
        Config config = this;
        config.nativeSetStreetscapeGeometryMode(config.nativeSymbolTableHandle, session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setInstantPlacementMode(InstantPlacementMode instantPlacementMode) {
        void var1_1;
        Config config = this;
        config.nativeSetInstantPlacementMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public InstantPlacementMode getInstantPlacementMode() {
        Config config = this;
        return InstantPlacementMode.forNumber(config.nativeGetInstantPlacementMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    @NonNull
    public ImageStabilizationMode getImageStabilizationMode() {
        Config config = this;
        return ImageStabilizationMode.forNumber(config.nativeGetImageStabilizationMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setImageStabilizationMode(ImageStabilizationMode imageStabilizationMode) {
        void var1_1;
        Config config = this;
        config.nativeSetImageStabilizationMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setDepthMode(DepthMode mode) {
        void var1_1;
        Config config = this;
        config.nativeSetDepthMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public DepthMode getDepthMode() {
        Config config = this;
        return DepthMode.forNumber(config.nativeGetDepthMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    @NonNull
    public SemanticMode getSemanticMode() {
        Config config = this;
        return SemanticMode.forNumber(config.nativeGetSemanticMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setSemanticMode(SemanticMode semanticMode) {
        void var1_1;
        Config config = this;
        config.nativeSetSemanticMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public TextureUpdateMode getTextureUpdateMode() {
        Config config = this;
        return TextureUpdateMode.forNumber(config.nativeGetTextureUpdateMode(config.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Config setTextureUpdateMode(TextureUpdateMode textureUpdateMode) {
        void var1_1;
        Config config = this;
        config.nativeSetTextureUpdateMode(config.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            Config.nativeDestroy(this.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    private static native long nativeCreate(long var0);

    private static native void nativeDestroy(long var0, long var2);

    private native int nativeGetLightEstimationMode(long var1, long var3);

    private native void nativeSetLightEstimationMode(long var1, long var3, int var5);

    private native int nativeGetPlaneFindingMode(long var1, long var3);

    private native void nativeSetPlaneFindingMode(long var1, long var3, int var5);

    private native int nativeGetUpdateMode(long var1, long var3);

    private native void nativeSetUpdateMode(long var1, long var3, int var5);

    private native void nativeSetCloudAnchorMode(long var1, long var3, int var5);

    private native int nativeGetCloudAnchorMode(long var1, long var3);

    private native void nativeSetAugmentedImageDatabase(long var1, long var3, long var5);

    private native long nativeGetAugmentedImageDatabase(long var1, long var3);

    private native int nativeGetAugmentedFaceMode(long var1, long var3);

    private native void nativeSetAugmentedFaceMode(long var1, long var3, int var5);

    private native int nativeGetFocusMode(long var1, long var3);

    private native void nativeSetFocusMode(long var1, long var3, int var5);

    private native int nativeGetGeospatialMode(long var1, long var3, long var5);

    private native void nativeSetGeospatialMode(long var1, long var3, long var5, int var7);

    private native int nativeGetStreetscapeGeometryMode(long var1, long var3, long var5);

    private native void nativeSetStreetscapeGeometryMode(long var1, long var3, long var5, int var7);

    private native void nativeSetInstantPlacementMode(long var1, long var3, int var5);

    private native int nativeGetInstantPlacementMode(long var1, long var3);

    private native int nativeGetImageStabilizationMode(long var1, long var3);

    private native void nativeSetImageStabilizationMode(long var1, long var3, int var5);

    private native int nativeGetDepthMode(long var1, long var3);

    private native void nativeSetDepthMode(long var1, long var3, int var5);

    private native int nativeGetSemanticMode(long var1, long var3);

    private native void nativeSetSemanticMode(long var1, long var3, int var5);

    private native int nativeGetTextureUpdateMode(long var1, long var3);

    private native void nativeSetTextureUpdateMode(long var1, long var3, int var5);

    public static enum LightEstimationMode {
        DISABLED(0),
        AMBIENT_INTENSITY(1),
        ENVIRONMENTAL_HDR(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private LightEstimationMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static LightEstimationMode forNumber(int nativeCode) {
            LightEstimationMode[] lightEstimationModeArray = LightEstimationMode.values();
            int n2 = lightEstimationModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    LightEstimationMode lightEstimationMode = lightEstimationModeArray[n3];
                    if (lightEstimationMode.nativeCode == n4) {
                        return lightEstimationMode;
                    }
                } else {
                    String string2 = "Unexpected value for native LightEstimationMode, value=";
                    throw new FatalException(p.b((byte)55, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum PlaneFindingMode {
        DISABLED(0),
        HORIZONTAL(1),
        VERTICAL(2),
        HORIZONTAL_AND_VERTICAL(3);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private PlaneFindingMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static PlaneFindingMode forNumber(int nativeCode) {
            PlaneFindingMode[] planeFindingModeArray = PlaneFindingMode.values();
            int n2 = planeFindingModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    PlaneFindingMode planeFindingMode = planeFindingModeArray[n3];
                    if (planeFindingMode.nativeCode == n4) {
                        return planeFindingMode;
                    }
                } else {
                    String string2 = "Unexpected value for native PlaneFindingMode, value=";
                    throw new FatalException(p.b((byte)52, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum UpdateMode {
        BLOCKING(0),
        LATEST_CAMERA_IMAGE(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private UpdateMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static UpdateMode forNumber(int nativeCode) {
            UpdateMode[] updateModeArray = UpdateMode.values();
            int n2 = updateModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    UpdateMode updateMode = updateModeArray[n3];
                    if (updateMode.nativeCode == n4) {
                        return updateMode;
                    }
                } else {
                    String string2 = "Unexpected value for native UpdateMode, value=";
                    throw new FatalException(p.b((byte)46, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum CloudAnchorMode {
        DISABLED(0),
        ENABLED(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private CloudAnchorMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static CloudAnchorMode forNumber(int nativeCode) {
            CloudAnchorMode[] cloudAnchorModeArray = CloudAnchorMode.values();
            int n2 = cloudAnchorModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    CloudAnchorMode cloudAnchorMode = cloudAnchorModeArray[n3];
                    if (cloudAnchorMode.nativeCode == n4) {
                        return cloudAnchorMode;
                    }
                } else {
                    String string2 = "Unexpected value for native AnchorHostingMode, value=";
                    throw new FatalException(p.b((byte)53, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum AugmentedFaceMode {
        DISABLED(0),
        MESH3D(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private AugmentedFaceMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static AugmentedFaceMode forNumber(int nativeCode) {
            AugmentedFaceMode[] augmentedFaceModeArray = AugmentedFaceMode.values();
            int n2 = augmentedFaceModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    AugmentedFaceMode augmentedFaceMode = augmentedFaceModeArray[n3];
                    if (augmentedFaceMode.nativeCode == n4) {
                        return augmentedFaceMode;
                    }
                } else {
                    String string2 = "Unexpected value for native AugmentedFaceMode, value=";
                    throw new FatalException(p.b((byte)53, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum FocusMode {
        FIXED(0),
        AUTO(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private FocusMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static FocusMode forNumber(int nativeCode) {
            FocusMode[] focusModeArray = FocusMode.values();
            int n2 = focusModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    FocusMode focusMode = focusModeArray[n3];
                    if (focusMode.nativeCode == n4) {
                        return focusMode;
                    }
                } else {
                    String string2 = "Unexpected value for native FocusMode, value=";
                    throw new FatalException(p.b((byte)45, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum GeospatialMode {
        DISABLED(0),
        ENABLED(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private GeospatialMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static GeospatialMode forNumber(int nativeCode) {
            GeospatialMode[] geospatialModeArray = GeospatialMode.values();
            int n2 = geospatialModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    GeospatialMode geospatialMode = geospatialModeArray[n3];
                    if (geospatialMode.nativeCode == n4) {
                        return geospatialMode;
                    }
                } else {
                    String string2 = "Unexpected value for native GeospatialMode, value=";
                    throw new FatalException(p.b((byte)50, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum StreetscapeGeometryMode {
        DISABLED(0),
        ENABLED(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private StreetscapeGeometryMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static StreetscapeGeometryMode forNumber(int nativeCode) {
            StreetscapeGeometryMode[] streetscapeGeometryModeArray = StreetscapeGeometryMode.values();
            int n2 = streetscapeGeometryModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    StreetscapeGeometryMode streetscapeGeometryMode = streetscapeGeometryModeArray[n3];
                    if (streetscapeGeometryMode.nativeCode == n4) {
                        return streetscapeGeometryMode;
                    }
                } else {
                    String string2 = "Unexpected value for native StreetscapeGeometryMode, value=";
                    throw new FatalException(p.b((byte)59, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum InstantPlacementMode {
        DISABLED(0),
        LOCAL_Y_UP(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private InstantPlacementMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        static InstantPlacementMode forNumber(int nativeCode) {
            InstantPlacementMode[] instantPlacementModeArray = InstantPlacementMode.values();
            int n2 = instantPlacementModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    InstantPlacementMode instantPlacementMode = instantPlacementModeArray[n3];
                    if (instantPlacementMode.nativeCode == n4) {
                        return instantPlacementMode;
                    }
                } else {
                    String string2 = "Unexpected value for native InstantPlacementMode, value=";
                    throw new FatalException(p.b((byte)56, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum ImageStabilizationMode {
        OFF(0),
        EIS(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private ImageStabilizationMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static ImageStabilizationMode forNumber(int nativeCode) {
            ImageStabilizationMode[] imageStabilizationModeArray = ImageStabilizationMode.values();
            int n2 = imageStabilizationModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    ImageStabilizationMode imageStabilizationMode = imageStabilizationModeArray[n3];
                    if (imageStabilizationMode.nativeCode == n4) {
                        return imageStabilizationMode;
                    }
                } else {
                    String string2 = "Unexpected value for native ImageStabilizationMode, value=";
                    throw new FatalException(p.b((byte)58, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum DepthMode {
        DISABLED(0),
        AUTOMATIC(1),
        RAW_DEPTH_ONLY(3);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private DepthMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static DepthMode forNumber(int nativeCode) {
            DepthMode[] depthModeArray = DepthMode.values();
            int n2 = depthModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    DepthMode depthMode = depthModeArray[n3];
                    if (depthMode.nativeCode == n4) {
                        return depthMode;
                    }
                } else {
                    String string2 = "Unexpected value for native DepthMode, value=";
                    throw new FatalException(p.b((byte)45, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum SemanticMode {
        DISABLED(0),
        ENABLED(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private SemanticMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static SemanticMode forNumber(int nativeCode) {
            SemanticMode[] semanticModeArray = SemanticMode.values();
            int n2 = semanticModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    SemanticMode semanticMode = semanticModeArray[n3];
                    if (semanticMode.nativeCode == n4) {
                        return semanticMode;
                    }
                } else {
                    String string2 = "Unexpected value for native SemanticMode, value=";
                    throw new FatalException(p.b((byte)48, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum TextureUpdateMode {
        BIND_TO_TEXTURE_EXTERNAL_OES(0),
        EXPOSE_HARDWARE_BUFFER(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private TextureUpdateMode(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        static TextureUpdateMode forNumber(int nativeCode) {
            TextureUpdateMode[] textureUpdateModeArray = TextureUpdateMode.values();
            int n2 = textureUpdateModeArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    TextureUpdateMode textureUpdateMode = textureUpdateModeArray[n3];
                    if (textureUpdateMode.nativeCode == n4) {
                        return textureUpdateMode;
                    }
                } else {
                    String string2 = "Unexpected value for native TextureUpdateMode, value=";
                    throw new FatalException(p.b((byte)53, n4, string2));
                }
                ++n3;
            }
        }
    }
}

