/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ar.core.Anchor;
import com.google.ar.core.GeospatialPose;
import com.google.ar.core.Pose;
import com.google.ar.core.ResolveAnchorOnRooftopFuture;
import com.google.ar.core.ResolveAnchorOnTerrainFuture;
import com.google.ar.core.Session;
import com.google.ar.core.TrackableBase;
import com.google.ar.core.TrackingState;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.p;
import java.util.function.BiConsumer;

public class Earth
extends TrackableBase {
    @NonNull
    public EarthState getEarthState() {
        Earth earth = this;
        return EarthState.forNumber(earth.nativeGetEarthState(earth.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    Earth(long nativeHandle, Session session) {
        super((long)var1_1, (Session)var3_2);
        void var3_2;
        void var1_1;
    }

    @NonNull
    public GeospatialPose getCameraGeospatialPose() {
        Session session = this.session;
        return new GeospatialPose(this.nativeGetCameraGeospatialPose(session.nativeWrapperHandle, this.nativeHandle), this.session);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GeospatialPose getGeospatialPose(Pose pose) {
        void var1_1;
        Session session = this.session;
        return new GeospatialPose(this.nativeGetGeospatialPose(session.nativeWrapperHandle, this.nativeHandle, (Pose)var1_1), this.session);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Pose getPose(double latitude, double longitude, double altitude, float qx, float qy, float qz, float qw) {
        void var10_7;
        void var9_6;
        void var8_5;
        void var7_4;
        void var5_3;
        void var3_2;
        void var1_1;
        Earth earth = this;
        return earth.nativeGetPose(earth.session.nativeWrapperHandle, this.nativeHandle, (double)var1_1, (double)var3_2, (double)var5_3, (float)var7_4, (float)var8_5, (float)var9_6, (float)var10_7);
    }

    @Override
    @Deprecated
    public Anchor createAnchor(Pose pose) {
        throw new IllegalArgumentException("Earth does not support createAnchor using a Pose. Use createAnchor with Geospatial coordinates instead.");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Anchor createAnchor(double latitude, double longitude, double altitude, float qx, float qy, float qz, float qw) {
        void var10_7;
        void var9_6;
        void var8_5;
        void var7_4;
        void var5_3;
        void var3_2;
        void var1_1;
        Session session = this.session;
        return new Anchor(this.nativeCreateAnchor(session.nativeWrapperHandle, this.nativeHandle, (double)var1_1, (double)var3_2, (double)var5_3, (float)var7_4, (float)var8_5, (float)var9_6, (float)var10_7), this.session);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Anchor createAnchor(double latitude, double longitude, double altitude, float[] rotation) {
        void var7_4;
        void var5_3;
        void var3_2;
        void var1_1;
        Session session = this.session;
        return new Anchor(this.nativeCreateAnchor(session.nativeWrapperHandle, this.nativeHandle, (double)var1_1, (double)var3_2, (double)var5_3, (float)var7_4[0], (float)var7_4[1], (float)var7_4[2], (float)var7_4[3]), this.session);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public Anchor resolveAnchorOnTerrain(double latitude, double longitude, double altitudeAboveTerrain, float qx, float qy, float qz, float qw) {
        void var10_7;
        void var9_6;
        void var8_5;
        void var7_4;
        void var5_3;
        void var3_2;
        void var1_1;
        Session session = this.session;
        return new Anchor(this.nativeResolveAnchorOnTerrain(session.nativeWrapperHandle, this.nativeHandle, (double)var1_1, (double)var3_2, (double)var5_3, (float)var7_4, (float)var8_5, (float)var9_6, (float)var10_7), this.session);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public ResolveAnchorOnTerrainFuture resolveAnchorOnTerrainAsync(double latitude, double longitude, double altitudeAboveTerrain, float qx, float qy, float qz, float qw, @Nullable BiConsumer<Anchor, Anchor.TerrainAnchorState> callback) {
        void var10_8;
        void var9_7;
        void var8_6;
        void var7_4;
        void var5_3;
        void var3_2;
        void var1_1;
        ResolveAnchorOnTerrainFuture.CallbackWrapper callbackWrapper;
        if (callback != null) {
            Session session = ((Earth)((Object)session)).session;
            callbackWrapper = new ResolveAnchorOnTerrainFuture.CallbackWrapper(session, (BiConsumer)((Object)callbackWrapper));
        } else {
            callbackWrapper = null;
        }
        Earth earth = session;
        long[] lArray = earth.nativeResolveAnchorOnTerrainAsync(earth.session.nativeWrapperHandle, ((Earth)((Object)session)).nativeHandle, (double)var1_1, (double)var3_2, (double)var5_3, (float)var7_4, (float)var8_6, (float)var9_7, (float)var10_8, callbackWrapper);
        Session session = ((Earth)((Object)session)).session;
        return new ResolveAnchorOnTerrainFuture(session, lArray[0], lArray[1]);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public ResolveAnchorOnRooftopFuture resolveAnchorOnRooftopAsync(double latitude, double longitude, double altitudeAboveRooftop, float qx, float qy, float qz, float qw, @Nullable BiConsumer<Anchor, Anchor.RooftopAnchorState> callback) {
        void var10_8;
        void var9_7;
        void var8_6;
        void var7_4;
        void var5_3;
        void var3_2;
        void var1_1;
        ResolveAnchorOnRooftopFuture.CallbackWrapper callbackWrapper;
        if (callback != null) {
            Session session = ((Earth)((Object)session)).session;
            callbackWrapper = new ResolveAnchorOnRooftopFuture.CallbackWrapper(session, (BiConsumer)((Object)callbackWrapper));
        } else {
            callbackWrapper = null;
        }
        Earth earth = session;
        long[] lArray = earth.nativeResolveAnchorOnRooftopAsync(earth.session.nativeWrapperHandle, ((Earth)((Object)session)).nativeHandle, (double)var1_1, (double)var3_2, (double)var5_3, (float)var7_4, (float)var8_6, (float)var9_7, (float)var10_8, callbackWrapper);
        Session session = ((Earth)((Object)session)).session;
        return new ResolveAnchorOnRooftopFuture(session, lArray[0], lArray[1]);
    }

    @Override
    @NonNull
    public TrackingState getTrackingState() {
        Earth earth = this;
        return TrackingState.forNumber(earth.nativeGetTrackingState(earth.session.nativeWrapperHandle, this.nativeHandle));
    }

    @Override
    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            Earth earth = this;
            earth.nativeReleaseEarth(earth.nativeSymbolTableHandle, l2);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    private native void nativeReleaseEarth(long var1, long var3);

    private native long nativeGetCameraGeospatialPose(long var1, long var3);

    private native int nativeGetEarthState(long var1, long var3);

    private native long nativeGetGeospatialPose(long var1, long var3, Pose var5);

    private native Pose nativeGetPose(long var1, long var3, double var5, double var7, double var9, float var11, float var12, float var13, float var14);

    private native int nativeGetTrackingState(long var1, long var3);

    private native long nativeCreateAnchor(long var1, long var3, double var5, double var7, double var9, float var11, float var12, float var13, float var14);

    private native long nativeResolveAnchorOnTerrain(long var1, long var3, double var5, double var7, double var9, float var11, float var12, float var13, float var14);

    private native long[] nativeResolveAnchorOnTerrainAsync(long var1, long var3, double var5, double var7, double var9, float var11, float var12, float var13, float var14, ResolveAnchorOnTerrainFuture.CallbackWrapper var15);

    private native long[] nativeResolveAnchorOnRooftopAsync(long var1, long var3, double var5, double var7, double var9, float var11, float var12, float var13, float var14, ResolveAnchorOnRooftopFuture.CallbackWrapper var15);

    public static enum EarthState {
        ENABLED(0),
        ERROR_INTERNAL(-1),
        ERROR_GEOSPATIAL_MODE_DISABLED(-2),
        ERROR_NOT_AUTHORIZED(-3),
        ERROR_RESOURCE_EXHAUSTED(-4),
        ERROR_APK_VERSION_TOO_OLD(-5);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private EarthState(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static EarthState forNumber(int nativeCode) {
            EarthState[] earthStateArray = EarthState.values();
            int n2 = earthStateArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    EarthState earthState = earthStateArray[n3];
                    if (earthState.nativeCode == n4) {
                        return earthState;
                    }
                } else {
                    String string2 = "Unexpected value for native EarthState, value=";
                    throw new FatalException(p.b((byte)46, n4, string2));
                }
                ++n3;
            }
        }
    }
}

