/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.media.Image;
import androidx.annotation.NonNull;
import com.google.ar.core.ArImage;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.p;

public class LightEstimate {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle = 0L;

    /*
     * WARNING - void declaration
     */
    LightEstimate(Session session) {
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = LightEstimate.nativeCreateLightEstimate(var1_1.nativeWrapperHandle);
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected LightEstimate() {
        this.session = null;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            LightEstimate.nativeDestroyLightEstimate(this.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    @NonNull
    public State getState() {
        LightEstimate lightEstimate = this;
        return State.forNumber(lightEstimate.nativeGetState(lightEstimate.session.nativeWrapperHandle, this.nativeHandle));
    }

    public float getPixelIntensity() {
        LightEstimate lightEstimate = this;
        return lightEstimate.nativeGetPixelIntensity(lightEstimate.session.nativeWrapperHandle, this.nativeHandle);
    }

    /*
     * WARNING - void declaration
     */
    public void getColorCorrection(float[] outColorCorrection4, int offset) {
        void var2_2;
        void var1_1;
        LightEstimate lightEstimate = this;
        lightEstimate.nativeGetColorCorrection(lightEstimate.session.nativeWrapperHandle, this.nativeHandle, (float[])var1_1, (int)var2_2);
    }

    public long getTimestamp() {
        LightEstimate lightEstimate = this;
        return lightEstimate.nativeGetTimestamp(lightEstimate.session.nativeWrapperHandle, this.nativeHandle);
    }

    public float[] getEnvironmentalHdrMainLightDirection() {
        LightEstimate lightEstimate = this;
        float[] fArray = new float[3];
        lightEstimate.nativeGetEnvironmentalHdrMainLightDirection(lightEstimate.session.nativeWrapperHandle, this.nativeHandle, fArray);
        return fArray;
    }

    public float[] getEnvironmentalHdrMainLightIntensity() {
        LightEstimate lightEstimate = this;
        float[] fArray = new float[3];
        lightEstimate.nativeGetEnvironmentalHdrMainLightIntensity(lightEstimate.session.nativeWrapperHandle, this.nativeHandle, fArray);
        return fArray;
    }

    public float[] getEnvironmentalHdrAmbientSphericalHarmonics() {
        LightEstimate lightEstimate = this;
        float[] fArray = new float[27];
        lightEstimate.nativeGetEnvironmentalHdrAmbientSphericalHarmonics(lightEstimate.session.nativeWrapperHandle, this.nativeHandle, fArray);
        return fArray;
    }

    public Image[] acquireEnvironmentalHdrCubeMap() {
        LightEstimate lightEstimate = this;
        long[] lArray = lightEstimate.nativeAcquireEnvironmentalHdrCubeMap(lightEstimate.session.nativeWrapperHandle, this.nativeHandle);
        Image[] imageArray = new ArImage[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            Session session = this.session;
            imageArray[i2] = new ArImage(session, lArray[i2]);
        }
        return imageArray;
    }

    private static native long nativeCreateLightEstimate(long var0);

    private static native void nativeDestroyLightEstimate(long var0, long var2);

    private native int nativeGetState(long var1, long var3);

    private native float nativeGetPixelIntensity(long var1, long var3);

    private native void nativeGetColorCorrection(long var1, long var3, float[] var5, int var6);

    private native long nativeGetTimestamp(long var1, long var3);

    private native void nativeGetEnvironmentalHdrMainLightDirection(long var1, long var3, float[] var5);

    private native void nativeGetEnvironmentalHdrMainLightIntensity(long var1, long var3, float[] var5);

    private native void nativeGetEnvironmentalHdrAmbientSphericalHarmonics(long var1, long var3, float[] var5);

    private native long[] nativeAcquireEnvironmentalHdrCubeMap(long var1, long var3);

    public static enum State {
        NOT_VALID(0),
        VALID(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private State(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static State forNumber(int nativeCode) {
            State[] stateArray = State.values();
            int n2 = stateArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    State state = stateArray[n3];
                    if (state.nativeCode == n4) {
                        return state;
                    }
                } else {
                    String string2 = "Unexpected value for native LightEstimate.State, value=";
                    throw new FatalException(p.b((byte)55, n4, string2));
                }
                ++n3;
            }
        }
    }
}

