/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Session;
import com.google.ar.core.exceptions.DeadlineExceededException;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class PointCloud
implements Closeable {
    private final Session session;
    private final long nativeSymbolTableHandle;
    private long nativeHandle;

    /*
     * WARNING - void declaration
     */
    PointCloud(Session session, long nativeHandle) {
        void var2_2;
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = var2_2;
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected PointCloud() {
        this.nativeHandle = 0L;
        this.session = null;
        this.nativeSymbolTableHandle = 0L;
    }

    public void release() {
        PointCloud pointCloud = this;
        pointCloud.nativeReleasePointCloud(pointCloud.nativeSymbolTableHandle, this.nativeHandle);
        this.nativeHandle = 0L;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            PointCloud pointCloud = this;
            pointCloud.nativeReleasePointCloud(pointCloud.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    public FloatBuffer getPoints() {
        long l2 = this.nativeHandle;
        if (l2 == 0L) {
            throw new DeadlineExceededException();
        }
        PointCloud pointCloud = this;
        return Session.directByteBufferOrDefault(pointCloud.nativeGetData(pointCloud.session.nativeWrapperHandle, l2)).asFloatBuffer();
    }

    public IntBuffer getIds() {
        long l2 = this.nativeHandle;
        if (l2 == 0L) {
            throw new DeadlineExceededException();
        }
        PointCloud pointCloud = this;
        return Session.directByteBufferOrDefault(pointCloud.nativeGetIds(pointCloud.session.nativeWrapperHandle, l2)).asIntBuffer();
    }

    public long getTimestamp() {
        long l2 = this.nativeHandle;
        if (l2 == 0L) {
            throw new DeadlineExceededException();
        }
        PointCloud pointCloud = this;
        return pointCloud.nativeGetTimestamp(pointCloud.session.nativeWrapperHandle, l2);
    }

    @Override
    public void close() {
        this.release();
    }

    private native ByteBuffer nativeGetData(long var1, long var3);

    private native ByteBuffer nativeGetIds(long var1, long var3);

    private native long nativeGetTimestamp(long var1, long var3);

    private native void nativeReleasePointCloud(long var1, long var3);
}

