/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.Anchor;
import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackingState;
import com.google.ar.core.annotations.UsedByNative;
import java.util.Collection;

@UsedByNative(value="trackable_base_jni.cc")
class TrackableBase
implements Trackable {
    long nativeHandle;
    protected final Session session;
    protected final long nativeSymbolTableHandle;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    TrackableBase(long nativeHandle, Session session) {
        void var1_1;
        void var3_2;
        this.session = var3_2;
        this.nativeHandle = var1_1;
        long l2 = var3_2 == null ? 0L : var3_2.nativeSymbolTableHandle;
        this.nativeSymbolTableHandle = l2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (!(obj instanceof TrackableBase)) {
            return false;
        }
        return ((TrackableBase)var1_1).nativeHandle == this.nativeHandle;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeHandle).hashCode();
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            TrackableBase.nativeReleaseTrackable(this.nativeSymbolTableHandle, l2);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    @Override
    @NonNull
    public TrackingState getTrackingState() {
        TrackableBase trackableBase = this;
        return TrackingState.forNumber(trackableBase.nativeGetTrackingState(trackableBase.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public Anchor createAnchor(Pose pose) {
        void var1_1;
        Session session = this.session;
        return new Anchor(this.nativeCreateAnchor(session.nativeWrapperHandle, this.nativeHandle, (Pose)var1_1), this.session);
    }

    @Override
    @NonNull
    public Collection<Anchor> getAnchors() {
        TrackableBase trackableBase = this;
        long[] lArray = trackableBase.nativeGetAnchors(trackableBase.session.nativeWrapperHandle, this.nativeHandle);
        return this.session.convertNativeAnchorsToCollection(lArray);
    }

    /*
     * WARNING - void declaration
     */
    static void internalReleaseNativeHandle(long nativeSymbolTableHandle, long trackableHandle) {
        void var2_1;
        TrackableBase.nativeReleaseTrackable(nativeSymbolTableHandle, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static int internalGetType(long sessionWrapperHandle, long trackableHandle) {
        void var2_1;
        return TrackableBase.nativeGetType(sessionWrapperHandle, (long)var2_1);
    }

    private static native void nativeReleaseTrackable(long var0, long var2);

    private static native int nativeGetType(long var0, long var2);

    private native int nativeGetTrackingState(long var1, long var3);

    private native long nativeCreateAnchor(long var1, long var3, Pose var5);

    private native long[] nativeGetAnchors(long var1, long var3);
}

