/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CreateFileOptions {
    public static final Map<String, byte[]> EMPTY_ATTRIBUTES = ImmutableMap.of();
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final CreateFileOptions DEFAULT = new CreateFileOptions(true, "application/octet-stream", EMPTY_ATTRIBUTES);
    private final boolean overwriteExisting;
    private final String contentType;
    private final Map<String, byte[]> attributes;

    public CreateFileOptions(boolean overwriteExisting) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, EMPTY_ATTRIBUTES);
    }

    public CreateFileOptions(boolean overwriteExisting, String contentType) {
        this(overwriteExisting, contentType, EMPTY_ATTRIBUTES);
    }

    public CreateFileOptions(boolean overwriteExisting, Map<String, byte[]> attributes) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, attributes);
    }

    public CreateFileOptions(boolean overwriteExisting, String contentType, Map<String, byte[]> attributes) {
        Preconditions.checkArgument((!attributes.containsKey("Content-Type") ? 1 : 0) != 0, (Object)"The Content-Type attribute must be provided explicitly via the 'contentType' parameter");
        this.overwriteExisting = overwriteExisting;
        this.contentType = contentType;
        this.attributes = attributes;
    }

    public boolean overwriteExisting() {
        return this.overwriteExisting;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }
}

