/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageResourceId {
    private static final Pattern OBJECT_NAME_IN_GCS_PATTERN = Pattern.compile("gs://(([^/]+)(/((.+))?)?)?");
    public static final StorageResourceId ROOT = new StorageResourceId();
    private final String bucketName;
    private final String objectName;
    private final String readableString;

    private StorageResourceId() {
        this.bucketName = null;
        this.objectName = null;
        this.readableString = StorageResourceId.createReadableString(this.bucketName, this.objectName);
    }

    public StorageResourceId(String bucketName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = null;
        this.readableString = StorageResourceId.createReadableString(bucketName, this.objectName);
    }

    public StorageResourceId(String bucketName, String objectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)objectName) ? 1 : 0) != 0, (Object)"objectName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.readableString = StorageResourceId.createReadableString(bucketName, objectName);
    }

    public boolean isStorageObject() {
        return this.bucketName != null && this.objectName != null;
    }

    public boolean isBucket() {
        return this.bucketName != null && this.objectName == null;
    }

    public boolean isRoot() {
        return this.bucketName == null && this.objectName == null;
    }

    public boolean isDirectory() {
        return this.isRoot() || this.isBucket() || StorageResourceId.objectHasDirectoryPath(this.objectName);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return this.readableString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageResourceId) {
            StorageResourceId other = (StorageResourceId)obj;
            return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName);
        }
        return false;
    }

    public int hashCode() {
        return this.readableString.hashCode();
    }

    public static String createReadableString(String bucketName, String objectName) {
        if (bucketName == null && objectName == null) {
            return "gs://";
        }
        if (bucketName != null && objectName == null) {
            return String.format("gs://%s", bucketName);
        }
        if (bucketName != null && objectName != null) {
            return String.format("gs://%s/%s", bucketName, objectName);
        }
        throw new IllegalArgumentException(String.format("Invalid bucketName/objectName pair: gs://%s/%s", bucketName, objectName));
    }

    static boolean objectHasDirectoryPath(String objectName) {
        return !Strings.isNullOrEmpty((String)objectName) && objectName.endsWith("/");
    }

    static String convertToDirectoryPath(String objectName) {
        if (!Strings.isNullOrEmpty((String)objectName) && !StorageResourceId.objectHasDirectoryPath(objectName)) {
            String string = String.valueOf(objectName);
            String string2 = String.valueOf("/");
            objectName = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        return objectName;
    }

    public static StorageResourceId fromObjectName(String objectName) {
        Matcher matcher = OBJECT_NAME_IN_GCS_PATTERN.matcher(objectName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"'%s' is not a valid GCS object name.", (Object[])new Object[]{objectName});
        String bucketName = matcher.group(2);
        String relativePath = matcher.group(4);
        if (bucketName == null) {
            return ROOT;
        }
        if (relativePath != null) {
            return new StorageResourceId(bucketName, relativePath);
        }
        return new StorageResourceId(bucketName);
    }
}

