/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InMemoryObjectReadChannel
extends GoogleCloudStorageReadChannel {
    private final byte[] channelContents;

    public InMemoryObjectReadChannel(byte[] channelContents) throws IOException {
        Preconditions.checkArgument((channelContents != null ? 1 : 0) != 0);
        this.channelContents = channelContents;
    }

    @Override
    protected InputStream openStreamAndSetMetadata(long newPosition) throws IOException {
        this.validatePosition(newPosition);
        this.setSize(this.channelContents.length);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.channelContents);
        ((InputStream)inputStream).skip(newPosition);
        return inputStream;
    }
}

