/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import java.io.IOException;
import java.util.List;

public class BigtableDataClient
implements AutoCloseable {
    private final EnhancedBigtableStub stub;

    public static BigtableDataClient create(InstanceName instanceName) throws IOException {
        BigtableDataSettings settings = BigtableDataSettings.newBuilder().setInstanceName(instanceName).build();
        return BigtableDataClient.create(settings);
    }

    public static BigtableDataClient create(BigtableDataSettings settings) throws IOException {
        EnhancedBigtableStub stub = EnhancedBigtableStub.create(settings.getTypedStubSettings());
        return new BigtableDataClient(stub);
    }

    @InternalApi(value="Visible for testing")
    BigtableDataClient(EnhancedBigtableStub stub) {
        this.stub = stub;
    }

    public ServerStream<Row> readRows(Query query) {
        return this.readRowsCallable().call((Object)query);
    }

    public void readRowsAsync(Query query, ResponseObserver<Row> observer) {
        this.readRowsCallable().call((Object)query, observer);
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public <RowT> ServerStreamingCallable<Query, RowT> readRowsCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowsCallable(rowAdapter);
    }

    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        return this.sampleRowKeysCallable().futureCall((Object)tableId);
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.stub.sampleRowKeysCallable();
    }

    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        return this.mutateRowCallable().futureCall((Object)rowMutation);
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.stub.mutateRowCallable();
    }

    @Override
    public void close() throws Exception {
        this.stub.close();
    }
}

