/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.v2.ColumnRange;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.TimestampRange;
import com.google.bigtable.v2.ValueRange;
import com.google.cloud.bigtable.data.v2.internal.RegexUtil;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;

public final class Filters {
    public static final Filters FILTERS = new Filters();
    private static final SimpleFilter PASS = new SimpleFilter(RowFilter.newBuilder().setPassAllFilter(true).build());
    private static final SimpleFilter BLOCK = new SimpleFilter(RowFilter.newBuilder().setBlockAllFilter(true).build());
    private static final SimpleFilter SINK = new SimpleFilter(RowFilter.newBuilder().setSink(true).build());
    private static final SimpleFilter STRIP_VALUE = new SimpleFilter(RowFilter.newBuilder().setStripValueTransformer(true).build());

    private Filters() {
    }

    public ChainFilter chain() {
        return new ChainFilter();
    }

    public InterleaveFilter interleave() {
        return new InterleaveFilter();
    }

    public ConditionFilter condition(@Nonnull Filter predicate) {
        Preconditions.checkNotNull((Object)predicate);
        return new ConditionFilter(predicate);
    }

    public KeyFilter key() {
        return new KeyFilter();
    }

    public FamilyFilter family() {
        return new FamilyFilter();
    }

    public QualifierFilter qualifier() {
        return new QualifierFilter();
    }

    public TimestampFilter timestamp() {
        return new TimestampFilter();
    }

    public ValueFilter value() {
        return new ValueFilter();
    }

    public OffsetFilter offset() {
        return new OffsetFilter();
    }

    public LimitFilter limit() {
        return new LimitFilter();
    }

    public Filter fromProto(RowFilter rowFilter) {
        return new SimpleFilter(rowFilter);
    }

    public Filter pass() {
        return PASS;
    }

    public Filter block() {
        return BLOCK;
    }

    public Filter sink() {
        return SINK;
    }

    public Filter label(@Nonnull String label) {
        Preconditions.checkNotNull((Object)label);
        return new SimpleFilter(RowFilter.newBuilder().setApplyLabelTransformer(label).build());
    }

    @InternalExtensionOnly
    public static interface Filter
    extends Cloneable {
        @InternalApi
        public RowFilter toProto();
    }

    private static final class SimpleFilter
    implements Filter {
        private final RowFilter proto;

        private SimpleFilter(@Nonnull RowFilter proto) {
            Preconditions.checkNotNull((Object)proto);
            this.proto = proto;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            return this.proto;
        }

        public SimpleFilter clone() {
            try {
                return (SimpleFilter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should never happen", e);
            }
        }
    }

    public static final class LimitFilter {
        private LimitFilter() {
        }

        public Filter cellsPerRow(int count) {
            return new SimpleFilter(RowFilter.newBuilder().setCellsPerRowLimitFilter(count).build());
        }

        public Filter cellsPerColumn(int count) {
            return new SimpleFilter(RowFilter.newBuilder().setCellsPerColumnLimitFilter(count).build());
        }
    }

    public static final class OffsetFilter {
        private OffsetFilter() {
        }

        public Filter cellsPerRow(int count) {
            return new SimpleFilter(RowFilter.newBuilder().setCellsPerRowOffsetFilter(count).build());
        }
    }

    public static final class ValueRangeFilter
    extends Range.AbstractByteStringRange<ValueRangeFilter>
    implements Filter {
        private ValueRangeFilter() {
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            ValueRange.Builder builder = ValueRange.newBuilder();
            switch (this.getStartBound()) {
                case CLOSED: {
                    builder.setStartValueClosed((ByteString)this.getStart());
                    break;
                }
                case OPEN: {
                    builder.setStartValueOpen((ByteString)this.getStart());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown start bound: " + (Object)((Object)this.getStartBound()));
                }
            }
            switch (this.getEndBound()) {
                case CLOSED: {
                    builder.setEndValueClosed((ByteString)this.getEnd());
                    break;
                }
                case OPEN: {
                    builder.setEndValueOpen((ByteString)this.getEnd());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown end bound: " + (Object)((Object)this.getEndBound()));
                }
            }
            return RowFilter.newBuilder().setValueRangeFilter(builder.build()).build();
        }

        @Override
        public ValueRangeFilter clone() {
            return (ValueRangeFilter)super.clone();
        }
    }

    public static final class ValueFilter {
        private ValueFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull((Object)regex);
            return this.regex(ByteString.copyFromUtf8((String)regex));
        }

        public Filter exactMatch(@Nonnull ByteString value) {
            Preconditions.checkNotNull((Object)value);
            return this.regex(RegexUtil.literalRegex(value));
        }

        public Filter regex(@Nonnull ByteString regex) {
            Preconditions.checkNotNull((Object)regex);
            return new SimpleFilter(RowFilter.newBuilder().setValueRegexFilter(regex).build());
        }

        public ValueRangeFilter range() {
            return new ValueRangeFilter();
        }

        public Filter strip() {
            return STRIP_VALUE;
        }
    }

    public static final class TimestampRangeFilter
    extends Range.AbstractTimestampRange<TimestampRangeFilter>
    implements Filter {
        private TimestampRangeFilter() {
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            TimestampRange.Builder builder = TimestampRange.newBuilder();
            switch (this.getStartBound()) {
                case CLOSED: {
                    builder.setStartTimestampMicros(((Long)this.getStart()).longValue());
                    break;
                }
                case OPEN: {
                    builder.setStartTimestampMicros((Long)this.getStart() + 1L);
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown start bound: " + (Object)((Object)this.getStartBound()));
                }
            }
            switch (this.getEndBound()) {
                case CLOSED: {
                    builder.setEndTimestampMicros((Long)this.getEnd() + 1L);
                    break;
                }
                case OPEN: {
                    builder.setEndTimestampMicros(((Long)this.getEnd()).longValue());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown end bound: " + (Object)((Object)this.getEndBound()));
                }
            }
            return RowFilter.newBuilder().setTimestampRangeFilter(builder.build()).build();
        }

        @Override
        public TimestampRangeFilter clone() {
            return (TimestampRangeFilter)super.clone();
        }
    }

    public static final class TimestampFilter {
        private TimestampFilter() {
        }

        public TimestampRangeFilter range() {
            return new TimestampRangeFilter();
        }
    }

    public static final class QualifierRangeFilter
    extends Range.AbstractByteStringRange<QualifierRangeFilter>
    implements Filter {
        private final String family;

        private QualifierRangeFilter(String family) {
            this.family = family;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            ColumnRange.Builder builder = ColumnRange.newBuilder().setFamilyName(this.family);
            switch (this.getStartBound()) {
                case CLOSED: {
                    builder.setStartQualifierClosed((ByteString)this.getStart());
                    break;
                }
                case OPEN: {
                    builder.setStartQualifierOpen((ByteString)this.getStart());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown start bound: " + (Object)((Object)this.getStartBound()));
                }
            }
            switch (this.getEndBound()) {
                case CLOSED: {
                    builder.setEndQualifierClosed((ByteString)this.getEnd());
                    break;
                }
                case OPEN: {
                    builder.setEndQualifierOpen((ByteString)this.getEnd());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown end bound: " + (Object)((Object)this.getEndBound()));
                }
            }
            return RowFilter.newBuilder().setColumnRangeFilter(builder.build()).build();
        }

        @Override
        public QualifierRangeFilter clone() {
            return (QualifierRangeFilter)super.clone();
        }
    }

    public static final class QualifierFilter {
        private QualifierFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull((Object)regex);
            return this.regex(ByteString.copyFromUtf8((String)regex));
        }

        public Filter regex(@Nonnull ByteString regex) {
            Preconditions.checkNotNull((Object)regex);
            return new SimpleFilter(RowFilter.newBuilder().setColumnQualifierRegexFilter(regex).build());
        }

        public Filter exactMatch(@Nonnull ByteString value) {
            Preconditions.checkNotNull((Object)value);
            return this.regex(RegexUtil.literalRegex(value));
        }

        public QualifierRangeFilter rangeWithinFamily(@Nonnull String family) {
            Preconditions.checkNotNull((Object)family);
            return new QualifierRangeFilter(family);
        }
    }

    public static final class FamilyFilter {
        private FamilyFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull((Object)regex);
            return new SimpleFilter(RowFilter.newBuilder().setFamilyNameRegexFilter(regex).build());
        }

        public Filter exactMatch(@Nonnull String value) {
            Preconditions.checkNotNull((Object)value);
            return this.regex(RegexUtil.literalRegex(value));
        }
    }

    public static final class KeyFilter {
        private KeyFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull((Object)regex);
            return this.regex(ByteString.copyFromUtf8((String)regex));
        }

        public Filter regex(@Nonnull ByteString regex) {
            Preconditions.checkNotNull((Object)regex);
            return new SimpleFilter(RowFilter.newBuilder().setRowKeyRegexFilter(regex).build());
        }

        public Filter exactMatch(@Nonnull ByteString value) {
            Preconditions.checkNotNull((Object)value);
            return this.regex(RegexUtil.literalRegex(value));
        }

        public Filter sample(double probability) {
            Preconditions.checkArgument((0.0 <= probability ? 1 : 0) != 0, (Object)"Probability must be positive");
            Preconditions.checkArgument((probability <= 1.0 ? 1 : 0) != 0, (Object)"Probability must be less than 1.0");
            return new SimpleFilter(RowFilter.newBuilder().setRowSampleFilter(probability).build());
        }
    }

    public static final class ConditionFilter
    implements Filter {
        private RowFilter.Condition.Builder builder;

        private ConditionFilter(@Nonnull Filter predicate) {
            Preconditions.checkNotNull((Object)predicate);
            this.builder = RowFilter.Condition.newBuilder().setPredicateFilter(predicate.toProto());
        }

        public ConditionFilter then(@Nonnull Filter filter) {
            Preconditions.checkNotNull((Object)filter);
            this.builder.setTrueFilter(filter.toProto());
            return this;
        }

        public ConditionFilter otherwise(@Nonnull Filter filter) {
            Preconditions.checkNotNull((Object)filter);
            this.builder.setFalseFilter(filter.toProto());
            return this;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            Preconditions.checkState((this.builder.hasTrueFilter() || this.builder.hasFalseFilter() ? 1 : 0) != 0, (Object)"ConditionFilter must have either a then or otherwise filter.");
            return RowFilter.newBuilder().setCondition(this.builder.build()).build();
        }

        public ConditionFilter clone() {
            try {
                ConditionFilter clone = (ConditionFilter)super.clone();
                clone.builder = this.builder.clone();
                return clone;
            }
            catch (ClassCastException | CloneNotSupportedException e) {
                throw new RuntimeException("should never happen");
            }
        }
    }

    public static final class InterleaveFilter
    implements Filter {
        private RowFilter.Interleave.Builder builder = RowFilter.Interleave.newBuilder();

        private InterleaveFilter() {
        }

        public InterleaveFilter filter(@Nonnull Filter filter) {
            Preconditions.checkNotNull((Object)filter);
            this.builder.addFilters(filter.toProto());
            return this;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            switch (this.builder.getFiltersCount()) {
                case 0: {
                    return PASS.toProto();
                }
                case 1: {
                    return this.builder.getFilters(0);
                }
            }
            return RowFilter.newBuilder().setInterleave(this.builder.build()).build();
        }

        public InterleaveFilter clone() {
            try {
                InterleaveFilter clone = (InterleaveFilter)super.clone();
                clone.builder = this.builder.clone();
                return clone;
            }
            catch (ClassCastException | CloneNotSupportedException e) {
                throw new RuntimeException("should never happen");
            }
        }
    }

    public static final class ChainFilter
    implements Filter {
        private RowFilter.Chain.Builder builder = RowFilter.Chain.newBuilder();

        private ChainFilter() {
        }

        public ChainFilter filter(@Nonnull Filter filter) {
            Preconditions.checkNotNull((Object)filter);
            this.builder.addFilters(filter.toProto());
            return this;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            switch (this.builder.getFiltersCount()) {
                case 0: {
                    return PASS.toProto();
                }
                case 1: {
                    return this.builder.getFilters(0);
                }
            }
            return RowFilter.newBuilder().setChain(this.builder.build()).build();
        }

        public ChainFilter clone() {
            try {
                ChainFilter clone = (ChainFilter)super.clone();
                clone.builder = this.builder.clone();
                return clone;
            }
            catch (ClassCastException | CloneNotSupportedException e) {
                throw new RuntimeException("should never happen");
            }
        }
    }
}

