/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.TableName;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;

public class Query {
    private final String tableId;
    private final ReadRowsRequest.Builder builder = ReadRowsRequest.newBuilder();

    public static Query create(String tableId) {
        return new Query(tableId);
    }

    private Query(String tableId) {
        this.tableId = tableId;
    }

    public Query rowKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null.");
        return this.rowKey(ByteString.copyFromUtf8((String)key));
    }

    public Query rowKey(ByteString key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null.");
        this.builder.getRowsBuilder().addRowKeys(key);
        return this;
    }

    public Query range(String start, String end) {
        return this.range(Query.wrapKey(start), Query.wrapKey(end));
    }

    public Query range(ByteString start, ByteString end) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        if (start != null) {
            rangeBuilder.setStartKeyClosed(start);
        }
        if (end != null) {
            rangeBuilder.setEndKeyOpen(end);
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query range(Range.ByteStringRange range) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        switch (range.getStartBound()) {
            case OPEN: {
                rangeBuilder.setStartKeyOpen((ByteString)range.getStart());
                break;
            }
            case CLOSED: {
                rangeBuilder.setStartKeyClosed((ByteString)range.getStart());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearStartKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown start bound: " + (Object)((Object)range.getStartBound()));
            }
        }
        switch (range.getEndBound()) {
            case OPEN: {
                rangeBuilder.setEndKeyOpen((ByteString)range.getEnd());
                break;
            }
            case CLOSED: {
                rangeBuilder.setEndKeyClosed((ByteString)range.getEnd());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearEndKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown end bound: " + (Object)((Object)range.getEndBound()));
            }
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query filter(Filters.Filter filter) {
        this.builder.setFilter(filter.toProto());
        return this;
    }

    public Query limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"Limit must be greater than 0.");
        this.builder.setRowsLimit(limit);
        return this;
    }

    @InternalApi
    public ReadRowsRequest toProto(RequestContext requestContext) {
        TableName tableName = TableName.of((String)requestContext.getInstanceName().getProject(), (String)requestContext.getInstanceName().getInstance(), (String)this.tableId);
        return this.builder.setTableName(tableName.toString()).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    private static ByteString wrapKey(String key) {
        if (key == null) {
            return null;
        }
        return ByteString.copyFromUtf8((String)key);
    }
}

