/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.contrib.nio.CloudStorageRetryHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CloudStorageReadChannel
implements SeekableByteChannel {
    private final Storage gcsStorage;
    private final BlobId file;
    @VisibleForTesting
    final int maxChannelReopens;
    final int maxRetries;
    private ReadChannel channel;
    private long position;
    private long size;

    @CheckReturnValue
    static CloudStorageReadChannel create(Storage gcsStorage, BlobId file, long position, int maxChannelReopens) throws IOException {
        return new CloudStorageReadChannel(gcsStorage, file, position, maxChannelReopens);
    }

    private CloudStorageReadChannel(Storage gcsStorage, BlobId file, long position, int maxChannelReopens) throws IOException {
        this.gcsStorage = gcsStorage;
        this.file = file;
        this.position = position;
        this.maxChannelReopens = maxChannelReopens;
        this.maxRetries = Math.max(3, maxChannelReopens);
        this.size = this.fetchSize(gcsStorage, file);
        this.innerOpen();
    }

    private void innerOpen() throws IOException {
        this.channel = this.gcsStorage.reader(this.file, new Storage.BlobSourceOption[0]);
        if (this.position > 0L) {
            this.channel.seek(this.position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            return this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            int amt;
            this.checkOpen();
            CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(this.maxRetries, this.maxChannelReopens);
            dst.mark();
            while (true) {
                try {
                    dst.reset();
                    amt = this.channel.read(dst);
                }
                catch (StorageException exs) {
                    this.handleStorageException(exs, retryHandler);
                    continue;
                }
                break;
            }
            if (amt > 0) {
                this.position += (long)amt;
                if (this.position > this.size) {
                    this.size = this.position;
                }
            }
            return amt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.checkOpen();
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.checkOpen();
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0);
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.checkOpen();
            if (newPosition == this.position) {
                return this;
            }
            this.channel.seek(newPosition);
            this.position = newPosition;
            return this;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private long fetchSize(Storage gcsStorage, BlobId file) throws IOException {
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(this.maxRetries, this.maxChannelReopens);
        while (true) {
            try {
                Blob blobInfo = gcsStorage.get(file);
                if (blobInfo == null) {
                    throw new NoSuchFileException(String.format("gs://%s/%s", file.getBucket(), file.getName()));
                }
                return blobInfo.getSize();
            }
            catch (StorageException exs) {
                retryHandler.handleStorageException(exs);
                continue;
            }
            break;
        }
    }

    private void handleStorageException(StorageException exs, CloudStorageRetryHandler retryHandler) throws IOException {
        boolean shouldReopen = retryHandler.handleStorageException(exs);
        if (shouldReopen) {
            this.innerOpen();
        }
    }
}

