/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.Provides;
import dagger.internal.codegen.binding.AutoValue_ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.model.BindingKind;
import dagger.model.Key;
import dagger.multibindings.Multibinds;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class ComponentRequirement {
    public abstract Kind kind();

    final boolean isBoundInstance() {
        return this.kind().isBoundInstance();
    }

    public abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    public TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    public TypeElement typeElement() {
        return MoreTypes.asTypeElement(this.type());
    }

    abstract Optional<NullPolicy> overrideNullPolicy();

    public NullPolicy nullPolicy(DaggerElements elements, KotlinMetadataUtil metadataUtil) {
        if (this.overrideNullPolicy().isPresent()) {
            return this.overrideNullPolicy().get();
        }
        switch (this.kind()) {
            case MODULE: {
                return ComponentRequirement.componentCanMakeNewInstances(this.typeElement(), metadataUtil) ? NullPolicy.NEW : (this.requiresAPassedInstance(elements, metadataUtil) ? NullPolicy.THROW : NullPolicy.ALLOW);
            }
            case DEPENDENCY: 
            case BOUND_INSTANCE: {
                return NullPolicy.THROW;
            }
        }
        throw new AssertionError();
    }

    public boolean requiresAPassedInstance(DaggerElements elements, KotlinMetadataUtil metadataUtil) {
        if (!this.kind().isModule()) {
            return true;
        }
        return this.requiresModuleInstance(elements, metadataUtil) && !ComponentRequirement.componentCanMakeNewInstances(this.typeElement(), metadataUtil);
    }

    private boolean requiresModuleInstance(DaggerElements elements, KotlinMetadataUtil metadataUtil) {
        boolean isKotlinObject;
        boolean bl = isKotlinObject = metadataUtil.isObjectClass(this.typeElement()) || metadataUtil.isCompanionObjectClass(this.typeElement());
        if (isKotlinObject) {
            return false;
        }
        ImmutableSet<ExecutableElement> methods = elements.getLocalAndInheritedMethods(this.typeElement());
        return methods.stream().filter(this::isBindingMethod).map(Element::getModifiers).anyMatch(modifiers -> !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC));
    }

    private boolean isBindingMethod(ExecutableElement method) {
        return DaggerElements.isAnyAnnotationPresent(method, Provides.class, Produces.class, Binds.class, Multibinds.class, BindsOptionalOf.class);
    }

    public abstract Optional<Key> key();

    public abstract String variableName();

    public ParameterSpec toParameterSpec() {
        return ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)this.type()), (String)this.variableName(), (Modifier[])new Modifier[0]).build();
    }

    public static ComponentRequirement forDependency(TypeMirror type) {
        return new AutoValue_ComponentRequirement(Kind.DEPENDENCY, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)((TypeMirror)Preconditions.checkNotNull((Object)type))), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(MoreTypes.asTypeElement(type)));
    }

    public static ComponentRequirement forModule(TypeMirror type) {
        return new AutoValue_ComponentRequirement(Kind.MODULE, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)((TypeMirror)Preconditions.checkNotNull((Object)type))), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(MoreTypes.asTypeElement(type)));
    }

    static ComponentRequirement forBoundInstance(Key key, boolean nullable, String variableName) {
        return new AutoValue_ComponentRequirement(Kind.BOUND_INSTANCE, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)key.type()), nullable ? Optional.of(NullPolicy.ALLOW) : Optional.empty(), Optional.of(key), variableName);
    }

    public static ComponentRequirement forBoundInstance(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.BOUND_INSTANCE));
        return ComponentRequirement.forBoundInstance(binding.key(), binding.nullableType().isPresent(), binding.bindingElement().get().getSimpleName().toString());
    }

    public static boolean componentCanMakeNewInstances(TypeElement typeElement, KotlinMetadataUtil metadataUtil) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)typeElement.getKind())));
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (ComponentRequirement.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        if (metadataUtil.isObjectClass(typeElement) || metadataUtil.isCompanionObjectClass(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !MoreElements.asExecutable(element).getParameters().isEmpty() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        throw new AssertionError((Object)("TypeElement cannot have nesting kind: " + (Object)((Object)typeElement.getNestingKind())));
    }

    public static enum NullPolicy {
        NEW,
        THROW,
        ALLOW;

    }

    public static enum Kind {
        DEPENDENCY,
        MODULE,
        BOUND_INSTANCE;


        public boolean isBoundInstance() {
            return this.equals((Object)BOUND_INSTANCE);
        }

        public boolean isModule() {
            return this.equals((Object)MODULE);
        }
    }
}

