/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import dagger.internal.codegen.binding.AutoValue_Nullability;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XNullability;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;

@AutoValue
public abstract class Nullability {
    public static final Nullability NOT_NULLABLE = new AutoValue_Nullability(false, Optional.empty());

    public static Nullability of(XElement element) {
        Optional<XAnnotation> nullableAnnotation = Nullability.getNullableAnnotation(element);
        boolean isNullable = Nullability.isKotlinTypeNullable(element) || nullableAnnotation.isPresent();
        return isNullable ? new AutoValue_Nullability(isNullable, nullableAnnotation) : NOT_NULLABLE;
    }

    private static boolean isKotlinTypeNullable(XElement element) {
        if (XElementKt.isMethod((XElement)element)) {
            return Nullability.isKotlinTypeNullable(XElements.asMethod(element).getReturnType());
        }
        if (XElementKt.isVariableElement((XElement)element)) {
            return Nullability.isKotlinTypeNullable(XElements.asVariable(element).getType());
        }
        return false;
    }

    private static boolean isKotlinTypeNullable(XType type) {
        return type.getNullability() == XNullability.NULLABLE;
    }

    private static Optional<XAnnotation> getNullableAnnotation(XElement element) {
        return element.getAllAnnotations().stream().filter(annotation -> XAnnotations.getClassName(annotation).simpleName().contentEquals("Nullable")).findFirst();
    }

    public abstract boolean isNullable();

    public abstract Optional<XAnnotation> nullableAnnotation();

    Nullability() {
    }
}

