/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_BindingGraphImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_BindingNodeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_ComponentNodeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DependencyEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_MissingBindingImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingKind;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerExecutableElement;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerType;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class SpiModelBindingGraphConverter {
    private SpiModelBindingGraphConverter() {
    }

    public static dagger.spi.model.DiagnosticReporter toSpiModel(DiagnosticReporter reporter) {
        return DiagnosticReporterImpl.create(reporter);
    }

    public static dagger.spi.model.BindingGraph toSpiModel(BindingGraph graph, XProcessingEnv env) {
        return BindingGraphImpl.create(graph, env);
    }

    private static ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> toSpiModel(Network<BindingGraph.Node, BindingGraph.Edge> internalNetwork, XProcessingEnv env) {
        MutableNetwork network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        ImmutableMap fromInternalNodes = (ImmutableMap)internalNetwork.nodes().stream().collect(DaggerStreams.toImmutableMap(node -> node, node -> SpiModelBindingGraphConverter.toSpiModel(node, env)));
        for (BindingGraph.Node node2 : fromInternalNodes.values()) {
            network.addNode((Object)node2);
        }
        for (BindingGraph.Edge edge : internalNetwork.edges()) {
            EndpointPair edgePair = internalNetwork.incidentNodes((Object)edge);
            network.addEdge((Object)((BindingGraph.Node)fromInternalNodes.get(edgePair.source())), (Object)((BindingGraph.Node)fromInternalNodes.get(edgePair.target())), (Object)SpiModelBindingGraphConverter.toSpiModel(edge, env));
        }
        return ImmutableNetwork.copyOf((Network)network);
    }

    private static BindingGraph.Node toSpiModel(BindingGraph.Node node, XProcessingEnv env) {
        if (node instanceof Binding) {
            return BindingNodeImpl.create((Binding)node, env);
        }
        if (node instanceof BindingGraph.ComponentNode) {
            return ComponentNodeImpl.create((BindingGraph.ComponentNode)node, env);
        }
        if (node instanceof BindingGraph.MissingBinding) {
            return MissingBindingImpl.create((BindingGraph.MissingBinding)node, env);
        }
        throw new IllegalStateException("Unhandled node type: " + node.getClass());
    }

    private static BindingGraph.Edge toSpiModel(BindingGraph.Edge edge, XProcessingEnv env) {
        if (edge instanceof BindingGraph.DependencyEdge) {
            return DependencyEdgeImpl.create((BindingGraph.DependencyEdge)edge, env);
        }
        if (edge instanceof BindingGraph.ChildFactoryMethodEdge) {
            return ChildFactoryMethodEdgeImpl.create((BindingGraph.ChildFactoryMethodEdge)edge, env);
        }
        if (edge instanceof BindingGraph.SubcomponentCreatorBindingEdge) {
            return SubcomponentCreatorBindingEdgeImpl.create((BindingGraph.SubcomponentCreatorBindingEdge)edge, env);
        }
        throw new IllegalStateException("Unhandled edge type: " + edge.getClass());
    }

    private static dagger.spi.model.Key toSpiModel(Key key, XProcessingEnv env) {
        Key.Builder builder = dagger.spi.model.Key.builder((DaggerType)SpiModelBindingGraphConverter.toSpiModel(key.type().xprocessing(), env)).qualifier(key.qualifier().map(qualifier -> SpiModelBindingGraphConverter.toSpiModel(qualifier.xprocessing(), env)));
        if (key.multibindingContributionIdentifier().isPresent()) {
            return builder.multibindingContributionIdentifier(SpiModelBindingGraphConverter.toSpiModel(key.multibindingContributionIdentifier().get().contributingModule().xprocessing(), env), SpiModelBindingGraphConverter.toSpiModel(key.multibindingContributionIdentifier().get().bindingMethod().xprocessing(), env)).build();
        }
        return builder.build().withoutMultibindingContributionIdentifier();
    }

    private static BindingKind toSpiModel(dagger.internal.codegen.model.BindingKind bindingKind) {
        return BindingKind.valueOf((String)bindingKind.name());
    }

    private static dagger.spi.model.RequestKind toSpiModel(RequestKind requestKind) {
        return dagger.spi.model.RequestKind.valueOf((String)requestKind.name());
    }

    private static DependencyRequest toSpiModel(dagger.internal.codegen.model.DependencyRequest request, XProcessingEnv env) {
        DependencyRequest.Builder builder = DependencyRequest.builder().kind(SpiModelBindingGraphConverter.toSpiModel(request.kind())).key(SpiModelBindingGraphConverter.toSpiModel(request.key(), env)).isNullable(request.isNullable());
        request.requestElement().ifPresent(e -> builder.requestElement(SpiModelBindingGraphConverter.toSpiModel(e.xprocessing(), env)));
        return builder.build();
    }

    private static Scope toSpiModel(dagger.internal.codegen.model.Scope scope, XProcessingEnv env) {
        return Scope.scope((DaggerAnnotation)SpiModelBindingGraphConverter.toSpiModel(scope.scopeAnnotation().xprocessing(), env));
    }

    private static ComponentPath toSpiModel(dagger.internal.codegen.model.ComponentPath path, XProcessingEnv env) {
        return ComponentPath.create((Iterable)((Iterable)path.components().stream().map(component -> SpiModelBindingGraphConverter.toSpiModel(component.xprocessing(), env)).collect(DaggerStreams.toImmutableList())));
    }

    private static DaggerTypeElement toSpiModel(XTypeElement typeElement, XProcessingEnv env) {
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerTypeElement.fromJavac((TypeElement)XConverters.toJavac((XTypeElement)typeElement));
            }
            case KSP: {
                return DaggerTypeElement.fromKsp((KSClassDeclaration)XConverters.toKS((XTypeElement)typeElement));
            }
        }
        throw new IllegalStateException(String.format("Backend %s is not supported yet.", env.getBackend()));
    }

    private static DaggerType toSpiModel(XType type, XProcessingEnv env) {
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerType.fromJavac((TypeMirror)XConverters.toJavac((XType)type));
            }
            case KSP: {
                return DaggerType.fromKsp((KSType)XConverters.toKS((XType)type));
            }
        }
        throw new IllegalStateException(String.format("Backend %s is not supported yet.", env.getBackend()));
    }

    static DaggerAnnotation toSpiModel(XAnnotation annotation, XProcessingEnv env) {
        DaggerTypeElement typeElement = SpiModelBindingGraphConverter.toSpiModel(annotation.getTypeElement(), env);
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerAnnotation.fromJavac((DaggerTypeElement)typeElement, (AnnotationMirror)XConverters.toJavac((XAnnotation)annotation));
            }
            case KSP: {
                return DaggerAnnotation.fromKsp((DaggerTypeElement)typeElement, (KSAnnotation)XConverters.toKS((XAnnotation)annotation));
            }
        }
        throw new IllegalStateException(String.format("Backend %s is not supported yet.", env.getBackend()));
    }

    private static DaggerElement toSpiModel(XElement element, XProcessingEnv env) {
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerElement.fromJavac((Element)XConverters.toJavac((XElement)element));
            }
            case KSP: {
                return DaggerElement.fromKsp((KSAnnotated)XElements.toKSAnnotated(element));
            }
        }
        throw new IllegalStateException(String.format("Backend %s is not supported yet.", env.getBackend()));
    }

    private static DaggerExecutableElement toSpiModel(XExecutableElement executableElement, XProcessingEnv env) {
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerExecutableElement.fromJava((ExecutableElement)XConverters.toJavac((XExecutableElement)executableElement));
            }
            case KSP: {
                return DaggerExecutableElement.fromKsp((KSFunctionDeclaration)XConverters.toKS((XExecutableElement)executableElement));
            }
        }
        throw new IllegalStateException(String.format("Backend %s is not supported yet.", env.getBackend()));
    }

    static DaggerProcessingEnv toSpiModel(XProcessingEnv env) {
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerProcessingEnv.fromJavac((ProcessingEnvironment)XConverters.toJavac((XProcessingEnv)env));
            }
            case KSP: {
                return DaggerProcessingEnv.fromKsp((SymbolProcessorEnvironment)XConverters.toKS((XProcessingEnv)env), (Resolver)XConverters.toKSResolver((XProcessingEnv)env));
            }
        }
        throw new IllegalStateException(String.format("Backend %s is not supported yet.", env.getBackend()));
    }

    private static BindingGraph.ComponentNode toInternal(BindingGraph.ComponentNode componentNode) {
        return ((ComponentNodeImpl)componentNode).internalDelegate();
    }

    private static BindingGraph.MaybeBinding toInternal(BindingGraph.MaybeBinding maybeBinding) {
        if (maybeBinding instanceof MissingBindingImpl) {
            return ((MissingBindingImpl)maybeBinding).internalDelegate();
        }
        if (maybeBinding instanceof BindingNodeImpl) {
            return ((BindingNodeImpl)maybeBinding).internalDelegate();
        }
        throw new IllegalStateException("Unhandled binding type: " + maybeBinding.getClass());
    }

    private static BindingGraph.DependencyEdge toInternal(BindingGraph.DependencyEdge dependencyEdge) {
        return ((DependencyEdgeImpl)dependencyEdge).internalDelegate();
    }

    private static BindingGraph.ChildFactoryMethodEdge toInternal(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge) {
        return ((ChildFactoryMethodEdgeImpl)childFactoryMethodEdge).internalDelegate();
    }

    private static final class DiagnosticReporterImpl
    extends dagger.spi.model.DiagnosticReporter {
        private final DiagnosticReporter delegate;

        static DiagnosticReporterImpl create(DiagnosticReporter reporter) {
            return new DiagnosticReporterImpl(reporter);
        }

        DiagnosticReporterImpl(DiagnosticReporter delegate) {
            this.delegate = delegate;
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String message) {
            this.delegate.reportComponent(diagnosticKind, SpiModelBindingGraphConverter.toInternal(componentNode), message);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.delegate.reportBinding(diagnosticKind, SpiModelBindingGraphConverter.toInternal(binding), message);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.delegate.reportDependency(diagnosticKind, SpiModelBindingGraphConverter.toInternal(dependencyEdge), message);
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, SpiModelBindingGraphConverter.toInternal(childFactoryMethodEdge), message);
        }
    }

    @AutoValue
    static abstract class BindingGraphImpl
    extends dagger.spi.model.BindingGraph {
        private ImmutableMap<ComponentPath, BindingGraph.ComponentNode> componentNodesByPath;

        BindingGraphImpl() {
        }

        static dagger.spi.model.BindingGraph create(BindingGraph bindingGraph, XProcessingEnv env) {
            AutoValue_SpiModelBindingGraphConverter_BindingGraphImpl bindingGraphImpl = new AutoValue_SpiModelBindingGraphConverter_BindingGraphImpl((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)SpiModelBindingGraphConverter.toSpiModel((Network<BindingGraph.Node, BindingGraph.Edge>)bindingGraph.network(), env), bindingGraph.isFullBindingGraph(), DaggerProcessingEnv.Backend.valueOf((String)env.getBackend().name()));
            bindingGraphImpl.componentNodesByPath = (ImmutableMap)bindingGraphImpl.componentNodes().stream().collect(DaggerStreams.toImmutableMap(BindingGraph.ComponentNode::componentPath, node -> node));
            return bindingGraphImpl;
        }

        public Optional<BindingGraph.ComponentNode> componentNode(ComponentPath componentPath) {
            return this.componentNodesByPath.containsKey((Object)componentPath) ? Optional.of((BindingGraph.ComponentNode)this.componentNodesByPath.get((Object)componentPath)) : Optional.empty();
        }

        @Memoized
        public ImmutableSetMultimap<Class<? extends BindingGraph.Node>, ? extends BindingGraph.Node> nodesByClass() {
            return super.nodesByClass();
        }
    }

    @AutoValue
    static abstract class SubcomponentCreatorBindingEdgeImpl
    implements BindingGraph.SubcomponentCreatorBindingEdge {
        SubcomponentCreatorBindingEdgeImpl() {
        }

        static BindingGraph.SubcomponentCreatorBindingEdge create(BindingGraph.SubcomponentCreatorBindingEdge subcomponentCreatorBindingEdge, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl((ImmutableSet<DaggerTypeElement>)((ImmutableSet)subcomponentCreatorBindingEdge.declaringModules().stream().map(module -> SpiModelBindingGraphConverter.toSpiModel(module.xprocessing(), env)).collect(DaggerStreams.toImmutableSet())), subcomponentCreatorBindingEdge);
        }

        abstract BindingGraph.SubcomponentCreatorBindingEdge internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class ChildFactoryMethodEdgeImpl
    implements BindingGraph.ChildFactoryMethodEdge {
        ChildFactoryMethodEdgeImpl() {
        }

        static BindingGraph.ChildFactoryMethodEdge create(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_ChildFactoryMethodEdgeImpl(SpiModelBindingGraphConverter.toSpiModel(childFactoryMethodEdge.factoryMethod().xprocessing(), env), childFactoryMethodEdge);
        }

        abstract BindingGraph.ChildFactoryMethodEdge internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class DependencyEdgeImpl
    implements BindingGraph.DependencyEdge {
        DependencyEdgeImpl() {
        }

        static BindingGraph.DependencyEdge create(BindingGraph.DependencyEdge dependencyEdge, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_DependencyEdgeImpl(SpiModelBindingGraphConverter.toSpiModel(dependencyEdge.dependencyRequest(), env), dependencyEdge.isEntryPoint(), dependencyEdge);
        }

        abstract BindingGraph.DependencyEdge internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class MissingBindingImpl
    extends BindingGraph.MissingBinding {
        MissingBindingImpl() {
        }

        static BindingGraph.MissingBinding create(BindingGraph.MissingBinding missingBinding, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_MissingBindingImpl(SpiModelBindingGraphConverter.toSpiModel(missingBinding.componentPath(), env), SpiModelBindingGraphConverter.toSpiModel(missingBinding.key(), env), missingBinding);
        }

        abstract BindingGraph.MissingBinding internalDelegate();

        @Memoized
        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    @AutoValue
    static abstract class BindingNodeImpl
    implements dagger.spi.model.Binding {
        BindingNodeImpl() {
        }

        static dagger.spi.model.Binding create(Binding binding, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_BindingNodeImpl(SpiModelBindingGraphConverter.toSpiModel(binding.key(), env), SpiModelBindingGraphConverter.toSpiModel(binding.componentPath(), env), (ImmutableSet<DependencyRequest>)((ImmutableSet)binding.dependencies().stream().map(request -> SpiModelBindingGraphConverter.toSpiModel(request, env)).collect(DaggerStreams.toImmutableSet())), binding.bindingElement().map(element -> SpiModelBindingGraphConverter.toSpiModel(element.xprocessing(), env)), binding.contributingModule().map(module -> SpiModelBindingGraphConverter.toSpiModel(module.xprocessing(), env)), binding.requiresModuleInstance(), binding.scope().map(scope -> SpiModelBindingGraphConverter.toSpiModel(scope, env)), binding.isNullable(), binding.isProduction(), SpiModelBindingGraphConverter.toSpiModel(binding.kind()), binding);
        }

        abstract Binding internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class ComponentNodeImpl
    implements BindingGraph.ComponentNode {
        ComponentNodeImpl() {
        }

        static BindingGraph.ComponentNode create(BindingGraph.ComponentNode componentNode, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_ComponentNodeImpl(SpiModelBindingGraphConverter.toSpiModel(componentNode.componentPath(), env), componentNode.isSubcomponent(), componentNode.isRealComponent(), (ImmutableSet<DependencyRequest>)((ImmutableSet)componentNode.entryPoints().stream().map(request -> SpiModelBindingGraphConverter.toSpiModel(request, env)).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<Scope>)((ImmutableSet)componentNode.scopes().stream().map(request -> SpiModelBindingGraphConverter.toSpiModel(request, env)).collect(DaggerStreams.toImmutableSet())), componentNode);
        }

        abstract BindingGraph.ComponentNode internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }
}

