/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

final class ExperimentalSwitchingProviderDependencyRepresentation {
    private final ProvisionBinding binding;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final BindsTypeChecker bindsTypeChecker;
    private final XProcessingEnv processingEnv;
    private final XType type;

    @AssistedInject
    ExperimentalSwitchingProviderDependencyRepresentation(@Assisted ProvisionBinding binding, ComponentImplementation componentImplementation, BindsTypeChecker bindsTypeChecker, XProcessingEnv processingEnv) {
        this.binding = binding;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.processingEnv = processingEnv;
        this.bindsTypeChecker = bindsTypeChecker;
        this.type = this.isDelegateSetValuesBinding() ? XTypes.rewrapType(binding.contributedType(), TypeNames.COLLECTION) : binding.contributedType();
    }

    Expression getDependencyExpression(RequestKind requestKind, ProvisionBinding requestingBinding) {
        int index = this.findIndexOfDependency(requestingBinding);
        XType frameworkType = this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((TypeName)FrameworkType.PROVIDER.frameworkClassName()), new XType[0]);
        Expression expression = FrameworkType.PROVIDER.to(requestKind, Expression.create(frameworkType, CodeBlock.of((String)"(($T) dependencies[$L])", (Object[])new Object[]{frameworkType.getRawType().getTypeName(), index})), this.processingEnv);
        if (this.usesExplicitTypeCast(expression, requestKind)) {
            return expression.castTo(this.type);
        }
        if (this.usesRawTypeCast(requestKind)) {
            return expression.castTo(this.type.getRawType());
        }
        return expression;
    }

    private int findIndexOfDependency(ProvisionBinding requestingBinding) {
        return ((ImmutableList)requestingBinding.dependencies().stream().map(DependencyRequest::key).collect(DaggerStreams.toImmutableList())).indexOf((Object)this.binding.key()) + (requestingBinding.requiresModuleInstance() && requestingBinding.contributingModule().isPresent() ? 1 : 0);
    }

    private boolean isDelegateSetValuesBinding() {
        return this.binding.kind().equals((Object)BindingKind.DELEGATE) && this.binding.contributionType().equals((Object)ContributionType.SET_VALUES);
    }

    private boolean usesExplicitTypeCast(Expression expression, RequestKind requestKind) {
        return requestKind.equals((Object)RequestKind.INSTANCE) && !this.bindsTypeChecker.isAssignable(expression.type(), this.type, this.binding.contributionType()) && Accessibility.isTypeAccessibleFrom(this.type, this.shardImplementation.name().packageName());
    }

    private boolean usesRawTypeCast(RequestKind requestKind) {
        return requestKind.equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(this.type, this.shardImplementation.name().packageName()) && Accessibility.isRawTypeAccessible(this.type, this.shardImplementation.name().packageName());
    }

    @AssistedFactory
    static interface Factory {
        public ExperimentalSwitchingProviderDependencyRepresentation create(ProvisionBinding var1);
    }
}

