/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.Nullability;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class MethodSignatureFormatter
extends Formatter<XExecutableElement> {
    private static final ClassName JET_BRAINS_NOT_NULL = ClassName.get((String)"org.jetbrains.annotations", (String)"NotNull", (String[])new String[0]);
    private static final ClassName JET_BRAINS_NULLABLE = ClassName.get((String)"org.jetbrains.annotations", (String)"Nullable", (String[])new String[0]);
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    MethodSignatureFormatter(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    public Formatter<XMethodElement> typedFormatter(final XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type));
        return new Formatter<XMethodElement>(){

            @Override
            public String format(XMethodElement method) {
                return MethodSignatureFormatter.this.format((XExecutableElement)method, (XExecutableType)method.asMemberOf(type), XElements.closestEnclosingTypeElement((XElement)method), true);
            }
        };
    }

    @Override
    public String format(XExecutableElement method) {
        return this.format(method, Optional.empty());
    }

    public String format(XExecutableElement method, Optional<XType> container) {
        return this.format(method, container, true);
    }

    private String format(XExecutableElement method, Optional<XType> container, boolean includeReturnType) {
        return container.isPresent() ? this.format(method, method.asMemberOf(container.get()), container.get().getTypeElement(), includeReturnType) : this.format(method, method.getExecutableType(), XElements.closestEnclosingTypeElement((XElement)method), includeReturnType);
    }

    private String format(XExecutableElement method, XExecutableType methodType, XTypeElement container, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        ImmutableList<String> formattedAnnotations = MethodSignatureFormatter.formatedAnnotations(method);
        if (!formattedAnnotations.isEmpty()) {
            builder.append(String.join((CharSequence)" ", formattedAnnotations)).append(" ");
        }
        if (XElements.getSimpleName((XElement)method).contentEquals("<init>")) {
            builder.append(container.getQualifiedName());
        } else {
            if (includeReturnType) {
                builder.append(MethodSignatureFormatter.nameOfType(((XMethodType)methodType).getReturnType())).append(' ');
            }
            builder.append(container.getQualifiedName()).append('.').append(XElements.getSimpleName((XElement)method));
        }
        builder.append('(');
        Preconditions.checkState((method.getParameters().size() == methodType.getParameterTypes().size() ? 1 : 0) != 0);
        Iterator parameters = method.getParameters().iterator();
        Iterator parameterTypes = methodType.getParameterTypes().iterator();
        int i = 0;
        while (parameters.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            this.appendParameter(builder, (XVariableElement)parameters.next(), (XType)parameterTypes.next());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    public String formatWithoutReturnType(XExecutableElement method) {
        return this.format(method, Optional.empty(), false);
    }

    private void appendParameter(StringBuilder builder, XVariableElement parameter, XType parameterType) {
        this.injectionAnnotations.getQualifier((XElement)parameter).ifPresent(qualifier -> builder.append(MethodSignatureFormatter.formatAnnotation(qualifier)).append(' '));
        builder.append(MethodSignatureFormatter.nameOfType(parameterType));
    }

    private static String nameOfType(XType type) {
        return DiagnosticFormatting.stripCommonTypePrefixes(XTypes.toStableString(type));
    }

    private static ImmutableList<String> formatedAnnotations(XExecutableElement executableElement) {
        Nullability nullability = Nullability.of((XElement)executableElement);
        ImmutableList formattedAnnotations = (ImmutableList)Streams.concat((Stream[])new Stream[]{executableElement.getAllAnnotations().stream().filter(annotation -> !annotation.getClassName().equals((Object)JET_BRAINS_NOT_NULL)).map(MethodSignatureFormatter::formatAnnotation), nullability.nullableAnnotations().stream().filter(annotation -> !annotation.equals((Object)JET_BRAINS_NOT_NULL)).map(annotation -> String.format("@%s", annotation.canonicalName()))}).distinct().collect(DaggerStreams.toImmutableList());
        if (nullability.isKotlinTypeNullable()) {
            if (nullability.nullableAnnotations().stream().noneMatch(arg_0 -> ((ClassName)JET_BRAINS_NULLABLE).equals(arg_0)) && XConverters.getProcessingEnv((XElement)executableElement).findTypeElement((TypeName)JET_BRAINS_NULLABLE) != null) {
                formattedAnnotations = ImmutableList.builder().addAll((Iterable)formattedAnnotations).add((Object)String.format("@%s", JET_BRAINS_NULLABLE.canonicalName())).build();
            }
        }
        return formattedAnnotations;
    }

    private static String formatAnnotation(XAnnotation annotation) {
        return DiagnosticFormatting.stripCommonTypePrefixes(XAnnotations.toString(annotation));
    }
}

