/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dagger.internal.codegen.binding.AutoValue_ResolvedBindings;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.Key;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;

@AutoValue
abstract class ResolvedBindings {
    ResolvedBindings() {
    }

    abstract ComponentPath componentPath();

    abstract Key key();

    abstract ImmutableSetMultimap<XTypeElement, ContributionBinding> allContributionBindings();

    abstract ImmutableMap<XTypeElement, MembersInjectionBinding> allMembersInjectionBindings();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    final ImmutableSetMultimap<XTypeElement, ? extends Binding> allBindings() {
        return !this.allMembersInjectionBindings().isEmpty() ? this.allMembersInjectionBindings().asMultimap() : this.allContributionBindings();
    }

    final ImmutableCollection<? extends Binding> bindings() {
        return this.allBindings().values();
    }

    final boolean isEmpty() {
        return this.allMembersInjectionBindings().isEmpty() && this.allContributionBindings().isEmpty() && this.multibindingDeclarations().isEmpty() && this.optionalBindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty();
    }

    ImmutableSet<? extends Binding> bindingsOwnedBy(ComponentDescriptor component) {
        return this.allBindings().get((Object)component.typeElement());
    }

    @Memoized
    ImmutableSet<ContributionBinding> contributionBindings() {
        return ImmutableSet.copyOf((Collection)this.allContributionBindings().values());
    }

    final XTypeElement owningComponent(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)this.contributionBindings().contains((Object)binding), (String)"binding is not resolved for %s: %s", (Object)this.key(), (Object)binding);
        return (XTypeElement)Iterables.getOnlyElement((Iterable)this.allContributionBindings().inverse().get((Object)binding));
    }

    static ResolvedBindings forContributionBindings(ComponentPath componentPath, Key key, Multimap<XTypeElement, ContributionBinding> contributionBindings, Iterable<MultibindingDeclaration> multibindings, Iterable<SubcomponentDeclaration> subcomponentDeclarations, Iterable<OptionalBindingDeclaration> optionalBindingDeclarations) {
        return new AutoValue_ResolvedBindings(componentPath, key, (ImmutableSetMultimap<XTypeElement, ContributionBinding>)ImmutableSetMultimap.copyOf(contributionBindings), (ImmutableMap<XTypeElement, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.copyOf(multibindings), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.copyOf(optionalBindingDeclarations));
    }

    static ResolvedBindings forMembersInjectionBinding(ComponentPath componentPath, Key key, ComponentDescriptor owningComponent, MembersInjectionBinding ownedMembersInjectionBinding) {
        return new AutoValue_ResolvedBindings(componentPath, key, (ImmutableSetMultimap<XTypeElement, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<XTypeElement, MembersInjectionBinding>)ImmutableMap.of((Object)owningComponent.typeElement(), (Object)ownedMembersInjectionBinding), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    static ResolvedBindings noBindings(ComponentPath componentPath, Key key) {
        return new AutoValue_ResolvedBindings(componentPath, key, (ImmutableSetMultimap<XTypeElement, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<XTypeElement, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }
}

