/*
 * Decompiled with CFR 0.152.
 */
package dagger.lint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.kotlin.KotlinUClass;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Ldagger/lint/DaggerKotlinIssueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isCompanionObject", "", "Lorg/jetbrains/uast/UClass;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isObject", "Companion", "java_dagger_lint-lint-artifact-lib"})
public final class DaggerKotlinIssueDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation SCOPES;
    private static final Issue ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT;
    private static final Issue ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION;
    private static final Issue ISSUE_MODULE_COMPANION_OBJECTS;
    private static final Issue ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT;
    private static final String PROVIDES_ANNOTATION = "dagger.Provides";
    private static final String JVM_STATIC_ANNOTATION = "kotlin.jvm.JvmStatic";
    private static final String INJECT_ANNOTATION = "javax.inject.Inject";
    private static final String QUALIFIER_ANNOTATION = "javax.inject.Qualifier";
    private static final String MODULE_ANNOTATION = "dagger.Module";
    @NotNull
    private static final List<Issue> issues;
    public static final Companion Companion;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UMethod.class, UField.class, UClass.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!Lint.isKotlin((PsiElement)((PsiElement)context.getPsiFile()))) {
            return null;
        }
        return new UElementHandler(this, context){
            final /* synthetic */ DaggerKotlinIssueDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitField(@NotNull UField node) {
                Object v0;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (!this.$context.getEvaluator().isLateInit((PsiModifierListOwner)node)) {
                        return;
                    }
                    Iterable iterable = node.getAnnotations();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    Iterator<T> iterator = iterable2.iterator();
                    while (iterator.hasNext()) {
                        T t = iterator.next();
                        UAnnotation it = (UAnnotation)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"javax.inject.Inject")) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                UAnnotation uAnnotation = v0;
                if (uAnnotation == null) {
                    return;
                }
                UAnnotation injectAnnotation = uAnnotation;
                Iterable $this$forEach$iv = node.getAnnotations();
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    PsiElement sourcePsi;
                    UAnnotation annotation = (UAnnotation)element$iv;
                    boolean bl = false;
                    if (annotation == injectAnnotation || !((sourcePsi = annotation.getSourcePsi()) instanceof KtAnnotationEntry)) continue;
                    KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ((KtAnnotationEntry)sourcePsi).getUseSiteTarget();
                    if ((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) != AnnotationUseSiteTarget.FIELD) continue;
                    PsiClass psiClass = annotation.resolve();
                    if (psiClass == null) continue;
                    if (!psiClass.hasAnnotation("javax.inject.Qualifier")) continue;
                    this.$context.report(DaggerKotlinIssueDetector.access$getISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION$cp(), this.$context.getLocation((UElement)annotation), DaggerKotlinIssueDetector.access$getISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION$cp().getBriefDescription(TextFormat.TEXT), LintFix.create().name("Remove 'field:'").replace().text("field:").with("").autoFix().build());
                }
            }

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (!node.isConstructor() && node.hasAnnotation("dagger.Provides") && node.hasAnnotation("kotlin.jvm.JvmStatic")) {
                    PsiClass psiClass = node.getContainingClass();
                    if (psiClass == null || (psiClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)psiClass), UClass.class)) == null) {
                        return;
                    }
                    PsiClass containingClass = psiClass;
                    if (DaggerKotlinIssueDetector.access$isObject(this.this$0, (UClass)containingClass)) {
                        UAnnotation uAnnotation = node.findAnnotation("kotlin.jvm.JvmStatic");
                        if (uAnnotation == null) {
                            Intrinsics.throwNpe();
                        }
                        UAnnotation annotation = uAnnotation;
                        this.$context.report(DaggerKotlinIssueDetector.access$getISSUE_JVM_STATIC_PROVIDES_IN_OBJECT$cp(), this.$context.getLocation((UElement)annotation), DaggerKotlinIssueDetector.access$getISSUE_JVM_STATIC_PROVIDES_IN_OBJECT$cp().getBriefDescription(TextFormat.TEXT), LintFix.create().name("Remove @JvmStatic").replace().pattern("(@(kotlin\\.jvm\\.)?JvmStatic)").with("").autoFix().build());
                    }
                }
            }

            public void visitClass(@NotNull UClass node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (node.hasAnnotation("dagger.Module") && DaggerKotlinIssueDetector.access$isCompanionObject(this.this$0, node, this.$context.getEvaluator())) {
                    UClass parent;
                    UElement uElement = UastContextKt.getUastParentOfType((PsiElement)((PsiElement)node), UClass.class, (boolean)false);
                    if (uElement == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((parent = (UClass)uElement).hasAnnotation("dagger.Module")) {
                        this.$context.report(DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS$cp(), this.$context.getLocation((UElement)node), DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS$cp().getBriefDescription(TextFormat.TEXT), LintFix.create().name("Remove @Module").replace().pattern("(@(dagger\\.)?Module)").with("").autoFix().build());
                    } else {
                        Context.report$default((Context)this.$context, (Issue)DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT$cp(), (Location)this.$context.getLocation((UElement)node), (String)DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT$cp().getBriefDescription(TextFormat.TEXT), null, (int)8, null);
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompanionObject(@NotNull UClass $this$isCompanionObject, JavaEvaluator evaluator) {
        if (!this.isObject($this$isCompanionObject)) return false;
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)$this$isCompanionObject;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierKeywordToken, (String)"KtTokens.COMPANION_KEYWORD");
        if (!evaluator.hasModifier(psiModifierListOwner, ktModifierKeywordToken)) return false;
        return true;
    }

    private final boolean isObject(@NotNull UClass $this$isObject) {
        return $this$isObject instanceof KotlinUClass && ((KotlinUClass)$this$isObject).getKtClass() instanceof KtObjectDeclaration;
    }

    static {
        Companion = new Companion(null);
        SCOPES = new Implementation(DaggerKotlinIssueDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), new EnumSet[]{EnumSet.of((Enum)Scope.JAVA_FILE), EnumSet.of((Enum)Scope.TEST_SOURCES)});
        ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT = Issue.Companion.create("JvmStaticProvidesInObjectDetector", "@JvmStatic used for @Provides function in an object class", "\n        It's redundant to annotate @Provides functions in object classes with @JvmStatic.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION = Issue.Companion.create("FieldSiteTargetOnQualifierAnnotation", "Redundant 'field:' used for Dagger qualifier annotation.", "\n        It's redundant to use 'field:' site-targets for qualifier annotations.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        ISSUE_MODULE_COMPANION_OBJECTS = Issue.Companion.create("ModuleCompanionObjects", "Module companion objects should not be annotated with @Module.", "\n        Companion objects in @Module-annotated classes are considered part of the API.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT = Issue.Companion.create("ModuleCompanionObjectsNotInModuleParent", "Companion objects should not be annotated with @Module.", "\n        Companion objects in @Module-annotated classes are considered part of the API. This\n        companion object is not a companion to an @Module-annotated class though, and should be\n        moved to a top-level object declaration instead otherwise Dagger will ignore companion\n        object.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        issues = CollectionsKt.listOf((Object[])new Issue[]{ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT, ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION, ISSUE_MODULE_COMPANION_OBJECTS, ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT});
    }

    public static final /* synthetic */ Issue access$getISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION$cp() {
        return ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION;
    }

    public static final /* synthetic */ boolean access$isObject(DaggerKotlinIssueDetector $this, UClass $this$access_u24isObject) {
        return $this.isObject($this$access_u24isObject);
    }

    public static final /* synthetic */ Issue access$getISSUE_JVM_STATIC_PROVIDES_IN_OBJECT$cp() {
        return ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT;
    }

    public static final /* synthetic */ boolean access$isCompanionObject(DaggerKotlinIssueDetector $this, UClass $this$access_u24isCompanionObject, JavaEvaluator evaluator) {
        return $this.isCompanionObject($this$access_u24isCompanionObject, evaluator);
    }

    public static final /* synthetic */ Issue access$getISSUE_MODULE_COMPANION_OBJECTS$cp() {
        return ISSUE_MODULE_COMPANION_OBJECTS;
    }

    public static final /* synthetic */ Issue access$getISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT$cp() {
        return ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldagger/lint/DaggerKotlinIssueDetector$Companion;", "", "()V", "INJECT_ANNOTATION", "", "ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION", "Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT", "ISSUE_MODULE_COMPANION_OBJECTS", "ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT", "JVM_STATIC_ANNOTATION", "MODULE_ANNOTATION", "PROVIDES_ANNOTATION", "QUALIFIER_ANNOTATION", "SCOPES", "Lcom/android/tools/lint/detector/api/Implementation;", "issues", "", "getIssues", "()Ljava/util/List;", "java_dagger_lint-lint-artifact-lib"})
    public static final class Companion {
        @NotNull
        public final List<Issue> getIssues() {
            return issues;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

