/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.AutoValue_BindingGraph;
import dagger.model.AutoValue_BindingGraph_MissingBinding;
import dagger.model.Binding;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class BindingGraph {
    private static final ImmutableSet<Class<? extends Node>> NODE_TYPES = ImmutableSet.of(Binding.class, MissingBinding.class, ComponentNode.class);

    static BindingGraph create(Network<Node, Edge> network, boolean isFullBindingGraph) {
        return new AutoValue_BindingGraph((ImmutableNetwork<Node, Edge>)ImmutableNetwork.copyOf(network), isFullBindingGraph);
    }

    BindingGraph() {
    }

    public abstract ImmutableNetwork<Node, Edge> network();

    public final String toString() {
        return this.network().toString();
    }

    @Deprecated
    public final boolean isModuleBindingGraph() {
        return !this.rootComponentNode().isRealComponent();
    }

    public abstract boolean isFullBindingGraph();

    @Deprecated
    public final boolean isPartialBindingGraph() {
        return this.rootComponentNode().isSubcomponent();
    }

    public final ImmutableSet<Binding> bindings() {
        return this.nodes(Binding.class);
    }

    public final ImmutableSet<Binding> bindings(Key key) {
        return this.nodes(Binding.class).stream().filter(binding -> binding.key().equals(key)).collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<MissingBinding> missingBindings() {
        return this.nodes(MissingBinding.class);
    }

    public final ImmutableSet<ComponentNode> componentNodes() {
        return this.nodes(ComponentNode.class);
    }

    public final Optional<ComponentNode> componentNode(ComponentPath component) {
        return this.componentNodes().stream().filter(node -> node.componentPath().equals(component)).findFirst();
    }

    public final ImmutableSet<ComponentNode> componentNodes(TypeElement component) {
        return this.componentNodes().stream().filter(node -> node.componentPath().currentComponent().equals(component)).collect(DaggerStreams.toImmutableSet());
    }

    public final ComponentNode rootComponentNode() {
        return this.componentNodes().stream().filter(node -> node.componentPath().atRoot()).findFirst().get();
    }

    public final ImmutableSet<DependencyEdge> dependencyEdges() {
        return this.dependencyEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSetMultimap<DependencyRequest, DependencyEdge> dependencyEdges(Binding binding) {
        return this.dependencyEdgeStream(binding).collect(DaggerStreams.toImmutableSetMultimap(DependencyEdge::dependencyRequest, edge -> edge));
    }

    public final ImmutableSet<DependencyEdge> dependencyEdges(DependencyRequest dependencyRequest) {
        return this.dependencyEdgeStream().filter(edge -> edge.dependencyRequest().equals(dependencyRequest)).collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<DependencyEdge> entryPointEdges(ComponentPath component) {
        return this.dependencyEdgeStream(this.componentNode(component).get()).collect(DaggerStreams.toImmutableSet());
    }

    private Stream<DependencyEdge> dependencyEdgeStream(Node node) {
        return this.network().outEdges((Object)node).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    public final ImmutableSet<DependencyEdge> entryPointEdges() {
        return this.entryPointEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<MaybeBinding> entryPointBindings() {
        return this.entryPointEdgeStream().map(edge -> (MaybeBinding)this.network().incidentNodes(edge).target()).collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<DependencyEdge> entryPointEdgesDependingOnBinding(MaybeBinding binding) {
        ImmutableNetwork<Node, DependencyEdge> dependencyGraph = this.dependencyGraph();
        MutableNetwork subgraphDependingOnBinding = Graphs.inducedSubgraph(dependencyGraph, (Iterable)Graphs.reachableNodes((Graph)Graphs.transpose(dependencyGraph).asGraph(), (Object)binding));
        return Sets.intersection(this.entryPointEdges(), (Set)subgraphDependingOnBinding.edges()).immutableCopy();
    }

    public final ImmutableSet<Binding> requestingBindings(MaybeBinding binding) {
        return this.network().predecessors((Object)binding).stream().flatMap(DaggerStreams.instancesOf(Binding.class)).collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<Binding> requestedBindings(Binding binding) {
        return this.network().successors((Object)binding).stream().flatMap(DaggerStreams.instancesOf(Binding.class)).collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<MaybeBinding> requestedMaybeMissingBindings(Binding binding) {
        return this.network().successors((Object)binding).stream().flatMap(DaggerStreams.instancesOf(MaybeBinding.class)).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableNetwork<Node, DependencyEdge> dependencyGraph() {
        MutableNetwork dependencyGraph = NetworkBuilder.from(this.network()).expectedNodeCount(this.network().nodes().size()).expectedEdgeCount((int)this.dependencyEdgeStream().count()).build();
        this.network().nodes().forEach(arg_0 -> ((MutableNetwork)dependencyGraph).addNode(arg_0));
        this.dependencyEdgeStream().forEach(edge -> {
            EndpointPair endpoints = this.network().incidentNodes(edge);
            dependencyGraph.addEdge((Object)((Node)endpoints.source()), (Object)((Node)endpoints.target()), edge);
        });
        return ImmutableNetwork.copyOf((Network)dependencyGraph);
    }

    private <N extends Node> ImmutableSet<N> nodes(Class<N> clazz) {
        return this.nodesByClass().get(clazz);
    }

    ImmutableSetMultimap<Class<? extends Node>, ? extends Node> nodesByClass() {
        return this.network().nodes().stream().collect(DaggerStreams.toImmutableSetMultimap(node -> NODE_TYPES.stream().filter(clazz -> clazz.isInstance(node)).findFirst().get(), node -> node));
    }

    private Stream<DependencyEdge> dependencyEdgeStream() {
        return this.network().edges().stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    private Stream<DependencyEdge> entryPointEdgeStream() {
        return this.dependencyEdgeStream().filter(DependencyEdge::isEntryPoint);
    }

    public static interface ComponentNode
    extends Node {
        @Override
        public ComponentPath componentPath();

        public boolean isSubcomponent();

        public boolean isRealComponent();

        public ImmutableSet<DependencyRequest> entryPoints();

        public ImmutableSet<Scope> scopes();
    }

    @AutoValue
    public static abstract class MissingBinding
    implements MaybeBinding {
        static MissingBinding create(ComponentPath component, Key key) {
            return new AutoValue_BindingGraph_MissingBinding(component, key);
        }

        @Override
        public abstract ComponentPath componentPath();

        @Override
        public abstract Key key();

        @Override
        @Deprecated
        public final Optional<Binding> binding() {
            return Optional.empty();
        }

        public final String toString() {
            return String.format("missing binding for %s in %s", this.key(), this.componentPath());
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    public static interface MaybeBinding
    extends Node {
        @Override
        public ComponentPath componentPath();

        public Key key();

        public Optional<Binding> binding();
    }

    public static interface Node {
        public ComponentPath componentPath();
    }

    public static interface SubcomponentCreatorBindingEdge
    extends Edge {
        public ImmutableSet<TypeElement> declaringModules();
    }

    public static interface ChildFactoryMethodEdge
    extends Edge {
        public ExecutableElement factoryMethod();
    }

    public static interface DependencyEdge
    extends Edge {
        public DependencyRequest dependencyRequest();

        public boolean isEntryPoint();
    }

    public static interface Edge {
    }
}

