/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.flags;

import android.content.Context;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.InstallIn;
import dagger.hilt.android.EntryPointAccessors;
import dagger.hilt.components.SingletonComponent;
import dagger.hilt.internal.Preconditions;
import dagger.multibindings.Multibinds;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;
import javax.inject.Qualifier;

public final class FragmentGetContextFix {
    public static boolean isFragmentGetContextFixDisabled(Context context) {
        Set<Boolean> flagSet = EntryPointAccessors.fromApplication(context, FragmentGetContextFixEntryPoint.class).getDisableFragmentGetContextFix();
        Preconditions.checkState((flagSet.size() <= 1 ? 1 : 0) != 0, (String)"Cannot bind the flag @DisableFragmentGetContextFix more than once.", (Object[])new Object[0]);
        if (flagSet.isEmpty()) {
            return false;
        }
        return flagSet.iterator().next();
    }

    private FragmentGetContextFix() {
    }

    @Module
    @InstallIn(value={SingletonComponent.class})
    static abstract class FragmentGetContextFixModule {
        FragmentGetContextFixModule() {
        }

        @Multibinds
        @DisableFragmentGetContextFix
        abstract Set<Boolean> disableFragmentGetContextFix();
    }

    @EntryPoint
    @InstallIn(value={SingletonComponent.class})
    public static interface FragmentGetContextFixEntryPoint {
        @DisableFragmentGetContextFix
        public Set<Boolean> getDisableFragmentGetContextFix();
    }

    @Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
    @Qualifier
    public static @interface DisableFragmentGetContextFix {
    }
}

