/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android;

import android.app.Application;
import android.content.Context;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.EarlyEntryPoint;
import dagger.hilt.android.internal.Contexts;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.GeneratedComponentManagerHolder;
import dagger.hilt.internal.Preconditions;
import dagger.hilt.internal.TestSingletonComponentManager;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;

public final class EarlyEntryPoints {
    @Nonnull
    public static <T> T get(Context applicationContext, Class<T> entryPoint) {
        Application application = Contexts.getApplication(applicationContext);
        Preconditions.checkState((boolean)(application instanceof GeneratedComponentManagerHolder), (String)"Expected application to implement GeneratedComponentManagerHolder. Check that you're passing in an application context that uses Hilt. Application class found: %s", (Object[])new Object[]{application.getClass()});
        GeneratedComponentManager componentManager = ((GeneratedComponentManagerHolder)application).componentManager();
        if (componentManager instanceof TestSingletonComponentManager) {
            Preconditions.checkState((boolean)EarlyEntryPoints.hasAnnotationReflection(entryPoint, EarlyEntryPoint.class), (String)"%s should be called with EntryPoints.get() rather than EarlyEntryPoints.get()", (Object[])new Object[]{entryPoint.getCanonicalName()});
            Object earlyComponent = ((TestSingletonComponentManager)componentManager).earlySingletonComponent();
            return entryPoint.cast(earlyComponent);
        }
        return (T)EntryPoints.get((Object)application, entryPoint);
    }

    private static boolean hasAnnotationReflection(Class<?> clazz, Class<? extends Annotation> annotationClazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationClazz)) continue;
            return true;
        }
        return false;
    }

    private EarlyEntryPoints() {
    }
}

