/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor7;
import javax.lang.model.util.Types;

public final class MoreTypes {
    private MoreTypes() {
    }

    public static DeclaredType getDeclaredType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor7<DeclaredType, Void>(){

            @Override
            public DeclaredType visitArray(ArrayType type, Void unused) {
                return MoreTypes.getDeclaredType(type.getComponentType());
            }

            @Override
            public DeclaredType visitDeclared(DeclaredType type, Void unused) {
                return type;
            }

            @Override
            public DeclaredType visitError(ErrorType type, Void unused) {
                return type;
            }

            @Override
            public DeclaredType defaultAction(TypeMirror type, Void unused) {
                throw new IllegalStateException("Unhandled type: " + type);
            }
        }, null);
    }

    public static TypeElement asTypeElement(TypeMirror type) {
        return MoreTypes.asTypeElement(MoreTypes.getDeclaredType(type));
    }

    public static TypeElement asTypeElement(DeclaredType type) {
        return (TypeElement)type.asElement();
    }

    public static ExecutableType asExecutable(TypeMirror maybeExecutableType) {
        return maybeExecutableType.accept(ExecutableTypeVisitor.INSTANCE, null);
    }

    public static Optional<ExecutableElement> findInheritedMethod(Types types, TypeElement classElement, ExecutableElement method) {
        Optional<ExecutableElement> match = Optional.empty();
        while (!match.isPresent() && !classElement.asType().getKind().equals((Object)TypeKind.NONE)) {
            match = MoreTypes.findMethod(types, classElement, method);
            classElement = MoreTypes.asTypeElement(classElement.getSuperclass());
        }
        return match;
    }

    public static Optional<ExecutableElement> findMethod(Types types, TypeElement classElement, ExecutableElement method) {
        ExecutableType methodType = MoreTypes.asExecutable(method.asType());
        Set matchingMethods = MoreTypes.findMethods(classElement, method.getSimpleName().toString()).stream().filter(clsMethod -> types.isSubsignature(MoreTypes.asExecutable(clsMethod.asType()), methodType)).collect(Collectors.toSet());
        Preconditions.checkState((matchingMethods.size() <= 1 ? 1 : 0) != 0, (String)"Found multiple methods with matching signature in class %s: %s", (Object)classElement, matchingMethods);
        return matchingMethods.size() == 1 ? Optional.of((ExecutableElement)Iterables.getOnlyElement(matchingMethods)) : Optional.empty();
    }

    public static Set<ExecutableElement> findMethods(TypeElement classElement, String name) {
        return ElementFilter.methodsIn(classElement.getEnclosedElements()).stream().filter(clsMethod -> clsMethod.getSimpleName().contentEquals(name)).collect(Collectors.toSet());
    }

    private static abstract class CastingTypeVisitor<T>
    extends SimpleTypeVisitor7<T, Void> {
        private final String label;

        CastingTypeVisitor(String label) {
            this.label = label;
        }

        @Override
        protected T defaultAction(TypeMirror e, Void v) {
            throw new IllegalArgumentException(e + " does not represent a " + this.label);
        }
    }

    private static final class ExecutableTypeVisitor
    extends CastingTypeVisitor<ExecutableType> {
        private static final ExecutableTypeVisitor INSTANCE = new ExecutableTypeVisitor();

        ExecutableTypeVisitor() {
            super("executable type");
        }

        @Override
        public ExecutableType visitExecutable(ExecutableType type, Void ignore) {
            return type;
        }
    }
}

