/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.JavaFile;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;

final class RootFileFormatter {
    private static final Pattern CLASS_PATERN = Pattern.compile("(\\h*)(.*class.*implements)(.*\\{)");

    static void write(JavaFile javaFile, XProcessingEnv env) throws IOException {
        ImmutableList originatingElements = (ImmutableList)javaFile.typeSpec.originatingElements.stream().map(element -> XConverters.toXProcessing((Element)element, (XProcessingEnv)env)).collect(DaggerStreams.toImmutableList());
        StringBuilder sb = new StringBuilder("");
        javaFile.writeTo((Appendable)sb);
        String fileContent = RootFileFormatter.formatInterfaces(sb.toString(), CLASS_PATERN);
        try (OutputStream outputStream = env.getFiler().writeSource(javaFile.packageName, javaFile.typeSpec.name, "java", (List)originatingElements, XFiler.Mode.Isolating);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            writer.write(fileContent);
        }
    }

    private static String formatInterfaces(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer(content.length());
        while (matcher.find()) {
            MatchResult result = matcher.toMatchResult();
            String spaces = result.group(1);
            String prefix = result.group(2);
            String interfaces = result.group(3);
            String formattedInterfaces = RootFileFormatter.formatInterfaces(spaces, interfaces);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(spaces + prefix + formattedInterfaces));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String formatInterfaces(String prefixSpaces, String interfaces) {
        StringBuilder sb = new StringBuilder(interfaces);
        String newLine = String.format("\n%s   ", prefixSpaces);
        int i = 0;
        int bracketCount = 0;
        while (i >= 0 && i < sb.length()) {
            char c;
            if ((c = sb.charAt(i++)) == '<') {
                ++bracketCount;
                continue;
            }
            if (c == '>') {
                --bracketCount;
                continue;
            }
            if (c != ',' || bracketCount != 0) continue;
            sb.insert(i++, newLine);
        }
        return sb.toString();
    }

    private RootFileFormatter() {
    }
}

