/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.ComponentGenerator;
import dagger.hilt.processor.internal.root.ComponentTree;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootFileFormatter;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class RootGenerator {
    private final XTypeElement originatingElement;
    private final RootMetadata metadata;
    private final XProcessingEnv env;
    private final Root root;
    private final Map<String, Integer> simpleComponentNamesToDedupeSuffix = new HashMap<String, Integer>();
    private final Map<ComponentDescriptor, ClassName> componentNameMap = new HashMap<ComponentDescriptor, ClassName>();
    private final ComponentNames componentNames;

    static void generate(ComponentTreeDepsMetadata componentTreeDepsMetadata, RootMetadata metadata, ComponentNames componentNames, XProcessingEnv env) throws IOException {
        new RootGenerator(componentTreeDepsMetadata, RootMetadata.copyWithNewTree(metadata, RootGenerator.filterDescriptors(metadata.componentTree())), componentNames, env).generateComponents();
    }

    private RootGenerator(ComponentTreeDepsMetadata componentTreeDepsMetadata, RootMetadata metadata, ComponentNames componentNames, XProcessingEnv env) {
        this.originatingElement = env.requireTypeElement(componentTreeDepsMetadata.name().toString());
        this.metadata = metadata;
        this.componentNames = componentNames;
        this.env = env;
        this.root = metadata.root();
    }

    private void generateComponents() throws IOException {
        ClassName componentsWrapperClassName = this.getComponentsWrapperClassName();
        TypeSpec.Builder componentsWrapper = TypeSpec.classBuilder((ClassName)componentsWrapperClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        Processors.addGeneratedAnnotation(componentsWrapper, this.env, ClassNames.ROOT_PROCESSOR.toString());
        ImmutableMap<ComponentDescriptor, ClassName> subcomponentBuilderModules = this.subcomponentBuilderModules(componentsWrapper);
        ComponentTree componentTree = this.metadata.componentTree();
        for (ComponentDescriptor componentDescriptor : componentTree.getComponentDescriptors()) {
            ImmutableSet modules = ImmutableSet.builder().addAll((Iterable)this.metadata.modules(componentDescriptor.component()).stream().map(XTypeElement::getClassName).collect(DaggerStreams.toImmutableSet())).addAll((Iterable)componentTree.childrenOf(componentDescriptor).stream().map(arg_0 -> subcomponentBuilderModules.get(arg_0)).collect(DaggerStreams.toImmutableSet())).build();
            componentsWrapper.addType(new ComponentGenerator(this.env, this.getComponentClassName(componentDescriptor), Optional.empty(), (Set<? extends ClassName>)modules, (Set<? extends TypeName>)this.metadata.entryPoints(componentDescriptor.component()), (ImmutableCollection<ClassName>)this.metadata.scopes(componentDescriptor.component()), (ImmutableList<AnnotationSpec>)ImmutableList.of(), this.componentAnnotation(componentDescriptor), this.componentBuilder(componentDescriptor)).typeSpecBuilder().addModifiers(new Modifier[]{Modifier.STATIC}).build());
        }
        JavaFile componentsWrapperJavaFile = JavaFile.builder((String)componentsWrapperClassName.packageName(), (TypeSpec)componentsWrapper.build()).build();
        RootFileFormatter.write(componentsWrapperJavaFile, this.env);
    }

    private static ComponentTree filterDescriptors(ComponentTree componentTree) {
        MutableGraph graph = GraphBuilder.from(componentTree.graph()).build();
        componentTree.graph().nodes().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        componentTree.graph().edges().forEach(arg_0 -> ((MutableGraph)graph).putEdge(arg_0));
        componentTree.getComponentDescriptors().stream().filter(descriptor -> !descriptor.isRoot() && !descriptor.creator().isPresent()).forEach(arg_0 -> ((MutableGraph)graph).removeNode(arg_0));
        return ComponentTree.from(Graphs.reachableNodes((Graph)graph, (Object)componentTree.root()));
    }

    private ImmutableMap<ComponentDescriptor, ClassName> subcomponentBuilderModules(TypeSpec.Builder componentsWrapper) {
        ImmutableMap.Builder modules = ImmutableMap.builder();
        for (ComponentDescriptor descriptor : this.metadata.componentTree().getComponentDescriptors()) {
            if (descriptor.isRoot() || !descriptor.creator().isPresent()) continue;
            ClassName component = this.getComponentClassName(descriptor);
            ClassName builder = descriptor.creator().get();
            ClassName module = component.peerClass(component.simpleName() + "BuilderModule");
            componentsWrapper.addType(this.subcomponentBuilderModule(component, builder, module));
            modules.put((Object)descriptor, (Object)module);
        }
        return modules.build();
    }

    private TypeSpec subcomponentBuilderModule(ClassName componentName, ClassName builderName, ClassName moduleName) {
        TypeSpec.Builder subcomponentBuilderModule = TypeSpec.interfaceBuilder((ClassName)moduleName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.MODULE).addMember("subcomponents", "$T.class", new Object[]{componentName}).build()).addAnnotation(ClassNames.DISABLE_INSTALL_IN_CHECK).addMethod(MethodSpec.methodBuilder((String)"bind").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addAnnotation(ClassNames.BINDS).returns((TypeName)builderName).addParameter((TypeName)componentName.nestedClass("Builder"), "builder", new Modifier[0]).build());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)subcomponentBuilderModule, (XElement)this.originatingElement);
        Processors.addGeneratedAnnotation(subcomponentBuilderModule, this.env, ClassNames.ROOT_PROCESSOR.toString());
        return subcomponentBuilderModule.build();
    }

    private Optional<TypeSpec> componentBuilder(ComponentDescriptor descriptor) {
        return descriptor.creator().map(creator -> {
            TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.ABSTRACT}).addSuperinterface((TypeName)creator).addAnnotation(this.componentBuilderAnnotation(descriptor));
            JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.originatingElement);
            return builder.build();
        });
    }

    private ClassName componentAnnotation(ComponentDescriptor componentDescriptor) {
        if (!componentDescriptor.isRoot()) {
            return ClassNames.SUBCOMPONENT;
        }
        return ClassNames.COMPONENT;
    }

    private ClassName componentBuilderAnnotation(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor.isRoot()) {
            return ClassNames.COMPONENT_BUILDER;
        }
        return ClassNames.SUBCOMPONENT_BUILDER;
    }

    private ClassName getPartialRootModuleClassName() {
        return this.getComponentsWrapperClassName().nestedClass("PartialRootModule");
    }

    private ClassName getComponentsWrapperClassName() {
        return this.componentNames.generatedComponentsWrapper(this.root.originatingRootClassname());
    }

    private ClassName getComponentClassName(ComponentDescriptor componentDescriptor) {
        if (this.componentNameMap.containsKey(componentDescriptor)) {
            return this.componentNameMap.get(componentDescriptor);
        }
        Preconditions.checkState((componentDescriptor.component().equals((Object)ClassNames.SINGLETON_COMPONENT) || !componentDescriptor.component().simpleName().equals(ClassNames.SINGLETON_COMPONENT.simpleName()) ? 1 : 0) != 0, (String)"Cannot have a component with the same simple name as the reserved %s: %s", (Object)ClassNames.SINGLETON_COMPONENT.simpleName(), (Object)componentDescriptor.component());
        ClassName generatedComponent = this.componentNames.generatedComponent(this.root.originatingRootClassname(), componentDescriptor.component());
        Integer suffix = this.simpleComponentNamesToDedupeSuffix.get(generatedComponent.simpleName());
        if (suffix != null) {
            generatedComponent = Processors.append(generatedComponent, String.valueOf(suffix));
            this.simpleComponentNamesToDedupeSuffix.put(generatedComponent.simpleName(), suffix + 1);
        } else {
            this.simpleComponentNamesToDedupeSuffix.put(generatedComponent.simpleName(), 2);
        }
        this.componentNameMap.put(componentDescriptor, generatedComponent);
        return generatedComponent;
    }
}

